// -----------------------------------------------------------------------------
#define SPON_THIS_FILE SPON\Core\addEventHandler
//
// Copyright (C) 2007 Bil Bas (bil.bagpuss@gmail.com \ Spooner)
// License: GNU General Public License, version 3 <http://www.gnu.org/licenses/>
//
// Last Modified: $Date: 2007/09/10 16:12:05 $
//
// Description:
//   Registers an event handler for a specific event.
//
// Parameters:
//   0: _eventType - Type of event to handle [String].
//   1: _handlerCode - Code to call when event is raised [Code].
//
// Returns:
//   Index of the event handler (can be used with SPON_removeEventHandler).
//
// -----------------------------------------------------------------------------

#include "debug.inc.sqf"
#include "macros.inc.sqf"

// -----------------------------------------------------------------------------

SPON_GET_PARAMS_2(_eventType,_handlerCode);

private ["_typeIndex", "_handlerIndex"];

_typeIndex = SPON_eventTypes find _eventType;

if (_typeIndex >= 0) then
{
	// Handlers for this event already exist, so add this one.
	private ["_handlers"];
	
	_handlers = SPON_eventHandlers select _typeIndex;
	
	SPON_PUSH(_handlers,_handlerCode);
	
	_handlerIndex = (count _handlers) - 1;
}
else
{
	// No handlers for this event already exist, so make a new event type.
	SPON_PUSH(SPON_eventTypes,_eventType);
	SPON_PUSH(SPON_eventHandlers,[_handlerCode]);
	
	_handlerIndex = 0;
	_typeIndex = (count SPON_eventTypes) - 1;;
};

SPON_TRACE_3("",_eventType,_typeIndex,_handlerIndex);

_handlerIndex; // Return.