// -----------------------------------------------------------------------------
#define SPON_THIS_FILE SPON\Core\addKeyEventHandler
//
// Copyright (C) 2007 Bil Bas (bil.bagpuss@gmail.com \ Spooner)
// License: GNU General Public License, version 3 <http://www.gnu.org/licenses/>
//
// Last Modified: $Date: 2007/09/14 13:06:56 $
//
// Description:
//   Registers an event handler for a specific key event.
//
// Parameters:
//   0: _eventType - Type of key event to handle [String: "UP" or "DOWN"].
//   1: _key - Keycode to detect [Scalar].
//   1: _code - Code to call when key event is raised [Code].
//
// Returns:
//   Index of the key event handler (can be used with SPON_removeKeyEventHandler).
//
// -----------------------------------------------------------------------------

#include "debug.inc.sqf"
#include "macros.inc.sqf"

#include "keyEventHandling.inc.sqf"

// -----------------------------------------------------------------------------

SPON_GET_PARAMS_3(_eventType,_key,_code);

assert (_eventType in SPON_VALID_KEY_HANDLER_TYPES);

private ["_keyIndex", "_validType", "_handlerIndex", "_keys", "_allHandlers"];

// Check whether we are using an up or down handler.
switch (_eventType) do
{
	case SPON_HANDLE_KEY_DOWN:
	{
		_keys = SPON_keyDownHandlerKeys;
		_allHandlers = SPON_keyDownHandlers;
		
	};
	case SPON_HANDLE_KEY_UP:
	{
		_keys = SPON_keyUpHandlerKeys;
		_allHandlers = SPON_keyUpHandlers;
	};
};

// Add this new key event handler to the list.
_keyIndex = _keys find _key;
	
if (_keyIndex >= 0) then
{
	// Handlers for this key already exist, so add to this list.
	_handlers = _allHandlers select _index;
	SPON_PUSH(_handlers,_code);
	
	_handlerIndex = (count _handlers) - 1;
}
else
{
	// No other handlers for this key, so add a new list of handlers.
	SPON_PUSH(_keys,_key);
	SPON_PUSH(_allHandlers,[_code]);
	
	_handlerIndex = 0;
};

SPON_TRACE_3("Added handler",_eventType,_key,_handlerIndex);

// Initialise the key event handlers with the game, if they haven't already been set.
if (not SPON_keyEventHandlersSet) then
{
	SPON_keyEventHandlersSet = true;
	
	[] spawn
	{
		private ["_rootdisplay"];
		
		// Ensure that the display is loaded before trying to add handlers.
		waitUntil { not (isNull (findDisplay 46)) };
		
		_rootdisplay = findDisplay 46;
		_rootdisplay displaySetEventHandler ["KeyUp", "_this call SPON_keyUpHandler;"];
		_rootdisplay displaySetEventHandler ["KeyDown", "_this call SPON_keyDownHandler;"];
	};
};

_handlerIndex; // Return.