// -----------------------------------------------------------------------------
#define SPON_THIS_FILE SPON\Core\initCore
//
// Copyright (C) 2007 Bil Bas (bil.bagpuss@gmail.com / Spooner)
// License: GNU General Public License, version 3 <http://www.gnu.org/licenses/>

// Description:
//
// Parameters:
//   0: _debugMode - Debug mode [String: "DEBUG_OFF", "DEBUG_CLIENT" or
//        "DEBUG_CLIENT_SERVER"]
//   1: _monitorVehiclesPollDelay - Delay between monitoring vehicles. This is
//        not used unless SPON_monitorVehicles is used.
//
// Description:
// 
// Parameters:
//   0: _debugMode - What level of debugging is required 
//      [String: "DEBUG_OFF", "DEBUG_CLIENT" or "DEBUG_CLIENT_SERVER"]
//   1: _monitorVehiclesPollDelay - Period (seconds) between checks when monitoring
//      vehicles. Not used unless SPON_monitorVehicles is called [Scalar, defaults to 15]
//
// Returns:
//   nil
//
// -----------------------------------------------------------------------------

#include "debug.inc.sqf"
#include "macros.inc.sqf"

#define DEBUG_MODE_OFF "DEBUG_OFF"
#define DEBUG_MODE_CLIENT "DEBUG_CLIENT"
#define DEBUG_MODE_CLIENT_SERVER "DEBUG_CLIENT_SERVER"

#define DEFAULT_VEHICLE_MONITOR_DELAY 15

// -----------------------------------------------------------------------------

SPON_GET_DEFAULT_PARAM(0,_debugMode,DEBUG_MODE_OFF);
SPON_GET_DEFAULT_PARAM(1,_monitorVehiclesPollDelay,DEFAULT_VEHICLE_MONITOR_DELAY);

assert (_debugMode in [DEBUG_MODE_OFF, DEBUG_MODE_CLIENT, DEBUG_MODE_CLIENT_SERVER]);

if (_debugMode in [DEBUG_MODE_CLIENT, DEBUG_MODE_CLIENT_SERVER]) then
{
	SPON_debugMode = true;
}
else
{
	SPON_debugMode = false;
};

SPON_monitorVehiclesPollDelay = _monitorVehiclesPollDelay;

// Suppliment the standard isServer command.
SPON_isClient = ((not isServer) or (not (isNull player)));
SPON_isDedicatedServer = (isServer and (isNull player));
SPON_isDedicatedClient = (not isServer);
SPON_isMP = SPON_isDedicatedServer or SPON_isDedicatedClient;

// Init other sub-components.
call compile preprocessFileLineNumbers "SPON\Core\initEventHandlers.sqf";
call compile preprocessFileLineNumbers "SPON\Core\initKeyEventHandlers.sqf";

// Allow for optional starting of vehicle monitoring at a later date.

SPON_monitorVehicles = compile preprocessFileLineNumbers "SPON\Core\monitorVehicles.sqf";

// Pre-compile utility functions.
SPON_formatTime = compile preprocessFileLineNumbers "SPON\Core\formatTime.sqf";

// Init the debug log if required.
if (SPON_debugMode) then
{
	private ["_debugServer"];
	
	_debugServer = (_debugMode == DEBUG_MODE_CLIENT_SERVER);
	
	[_debugServer, false] call compile preprocessFileLineNumbers "SPON\Core\initDebugLog.sqf";
};

SPON_TRACE_2("",_debugMode,SPON_monitorVehiclesPollDelay);

nil; // Return.