// -----------------------------------------------------------------------------
#define SPON_THIS_FILE SPON\Core\initEventHandlers
//
// Copyright (C) 2007 Bil Bas (bil.bagpuss@gmail.com \ Spooner)
// License: GNU General Public License, version 3 <http://www.gnu.org/licenses/>
//
// Last Modified: $Date: 2007/09/14 13:06:56 $
//
// Description:
//   Initialise the use of global and local event handling.
//
// -----------------------------------------------------------------------------

// File may be called several times, but only init once.
if (not (isNil {SPON_addEventHandler})) exitWith {};

#include "debug.inc.sqf"
#include "macros.inc.sqf"

// -----------------------------------------------------------------------------

SPON_serializeSide =
{
	SPON_GET_PARAMS_1(_side);
	
	SPON_sidesForSerializing find _side; // Return.
};

// -----------------------------------------------------------------------------

SPON_unserializeSide =
{
	SPON_GET_PARAMS_1(_sideIndex);
	
	SPON_sidesForSerializing select _sideIndex; // Return.
};
	
// ---------------------------------------------------------------------------
// Function: SPON_publishGlobalEvent
//
// Description:
//   Raises an event on all machines.
//   _params MUST be serialisable, so no objects, groups, etc!
//
// Parameters:
//   0: _eventType - Type of event to publish [String].
//   1: _params - Parameters to pass to the event handlers [Array].
//
// Returns:
//   nil
//
// ---------------------------------------------------------------------------
SPON_publishGlobalEvent =
{
	SPON_GET_PARAMS_2(_eventType,_params);

	// Just send the message.
	SPON_globalEventPublisher setVehicleInit 
		(format ['nil=["%1",%2] call SPON_e', _eventType, _params]);
	processInitCommands;
};


// -----------------------------------------------------------------------------
// Function: SPON_publishLocalEvent
//
// Description:
//   Raises an event only on the local machines.
//
// Parameters:
//   0: _eventType - Type of event to publish [String].
//   1: _params - Parameters to pass to the event handlers [Array].
//
// Returns:
//   nil
//
// -----------------------------------------------------------------------------
SPON_publishLocalEvent =
{
	SPON_GET_PARAMS_2(_eventType,_params);
	
	private ["_typeIndex"];
	_typeIndex = SPON_eventTypes find _eventType;

	if (_typeIndex >= 0) then
	{
		private ["_handlers"];
		
		_handlers = SPON_eventHandlers select _typeIndex;
		
		// Handle the event on all the currently enabled handlers.
		{
			// Run the code if it hasn't been removed.
			if (SPON_IS_CODE(_x)) then
			{
				_params call _x;
			};
		} forEach _handlers;
	};
};

// -----------------------------------------------------------------------------

// Pre-load required functions.
SPON_addEventHandler = compile preprocessFileLineNumbers "SPON\Core\addEventHandler.sqf";
SPON_removeEventHandler = compile preprocessFileLineNumbers "SPON\Core\removeEventHandler.sqf";

// "Association" of handled event names [String] => event handlers [Code]
SPON_eventTypes = [];
SPON_eventHandlers = [];

// This is a dummy local object that is used when publishing global events.
SPON_globalEventPublisher = "HeliHEmpty" createVehicle [0, 0, 0];

// Alias so that sending global events uses less bandwidth.
SPON_e = SPON_publishLocalEvent;

// Side list for the serialise/unserialiseSide functions.
SPON_sidesForSerializing = [west, east, resistance, civilian, friendly, enemy];

nil; // Return.