// -----------------------------------------------------------------------------
// Function: SPON_monitorVehicles
//
// Copyright (C) 2007 Bil Bas (bil.bagpuss@gmail.com / Spooner)
// License: GNU General Public License, version 3 <http://www.gnu.org/licenses/>
//
// Last Modified: $Date: 2007/09/14 13:06:56 $
//
// Description:
//   Initialise and begin vehicle and man monitoring.
//
// Parameters:
//   None
//
// Returns:
//   nil
//
// -----------------------------------------------------------------------------

#include "debug.inc.sqf"
#include "macros.inc.sqf"

// -----------------------------------------------------------------------------

// Only start monitoring once.
if (not (isNil {SPON_men})) exitWith { nil; };

// Keep records of all the men and vehicles in the game.
SPON_men = [];
SPON_vehicles = [];

// Associative lists (can use "in"/"find" on objects or names).
SPON_players_object = [];
SPON_players_name = [];
SPON_players_connected = [];

SPON_recordVehicles = compile preprocessFileLineNumbers "SPON\Core\recordVehicles.sqf";

// -----------------------------------------------------------------------------
// Since the vehicles command is "broken" (it doesn't return soldiers),
// manually look for men and vehicles.

// Find all Vehicles (Following code adapted from CENT_tracers).
SPON_worldTrigger = createTrigger ["EmptyDetector",
	getArray(configFile >> "CfgWorlds" >> worldName >> "centerPosition")];
SPON_worldTrigger setTriggerType "NONE";
SPON_worldTrigger setTriggerActivation ["ANY", "PRESENT", true];
SPON_worldTrigger setTriggerArea [50000, 50000, 0, false];
SPON_worldTrigger setTriggerStatements ["this", "", ""];

SPON_recordVehiclesRunBefore = false;

// Monitor for newly added vehicles.
[] spawn
{
	while {true} do
	{
		call SPON_recordVehicles;
		
		sleep SPON_monitorVehiclesPollDelay; // Set by coreInit.sqf
	};
};

nil; // Return.