// -----------------------------------------------------------------------------
#define SPON_THIS_FILE SPON\Core\removeEventHandler
//
// Copyright (C) 2007 Bil Bas (bil.bagpuss@gmail.com \ Spooner)
// License: GNU General Public License, version 3 <http://www.gnu.org/licenses/>
//
// Last Modified: $Date: 2007/09/10 16:12:05 $
//
// Description:
//   Removes an event handler previously registered with SPON_addEventHandler.
//
// Parameters:
//   0: _eventType - Type of event to handle [String].
//   1: _handlerIndex - Index of the event handler to remove [Scalar].
//
// Returns:
//   nil
//
// -----------------------------------------------------------------------------

#include "debug.inc.sqf"
#include "macros.inc.sqf"

// -----------------------------------------------------------------------------

SPON_GET_PARAMS_2(_eventType,_handlerIndex);

private ["_typeIndex"];
_typeIndex = SPON_eventTypes find _eventType;

if (_typeIndex >= 0) then
{
	private ["_handlers"];
	
	_handlers = SPON_eventHandlers select _typeIndex;
	_handlers set [_handlerIndex, nil];
};

SPON_TRACE_2("",_eventType,_handlerIndex);

nil; // Return.