// -----------------------------------------------------------------------------
#define SPON_THIS_FILE SPON\CORE\viewDebugLog
//
// Copyright (C) 2007 Bil Bas (bil.bagpuss@gmail.com \ Spooner)
// License: GNU General Public License, version 3 <http://www.gnu.org/licenses/>
//
// Last Modified: $Date: 2007/09/10 17:58:21 $
//
// Description:
//   Shows the debug log.
//
// Parameters:
//   none
//
// Returns:
//   nil
//
// -----------------------------------------------------------------------------

#include "debug.inc.sqf"
#include "macros.inc.sqf"
#include "ui\handles.hpp"

// -----------------------------------------------------------------------------
// Function: SPON_debugClientListSelChanged
//
// Description:
//   Updates the edit-box below the client log when the selection is changed.
//
SPON_debugClientListSelChanged = 
{
	SPON_GET_PARAMS_2(_control,_index);
	
	_text = lbText [SPON_DEBUG_CLIENT_LIST_IDC, _index];
	ctrlSetText [SPON_DEBUG_CLIENT_EDIT_IDC, _text];

	nil; // Return.
};

// -----------------------------------------------------------------------------
// Function: SPON_debugServerListSelChanged
//
// Description:
//   Updates the edit-box below the server log when the selection is changed.
//
SPON_debugServerListSelChanged =
{
	SPON_GET_PARAMS_2(_control,_index);

	_text = lbText [SPON_DEBUG_SERVER_LIST_IDC, _index];
	ctrlSetText [SPON_DEBUG_SERVER_EDIT_IDC, _text];
	
	nil; // Return.
};

// -----------------------------------------------------------------------------
_ok = createDialog "SPON_dlgDebugLog";
if (!_ok) exitWith { hint "Failed to open debug log window."; nil; };

// Fill up the log and scroll down to the last entry.
call SPON_debugFillLog;

nil; // Return.