// -----------------------------------------------------------------------------
#define SPON_THIS_FILE SPON\VBIED\detonateVBIEDAction
//
// Copyright (C) 2007 Bil Bas (bil.bagpuss@gmail.com \ Spooner)
// License: GNU General Public License, version 3 <http://www.gnu.org/licenses/>
//
// Last Modified: $Date: 2007/10/01 17:38:54 $
//
// Last Modified:
//
// Description:
//   Detonate VBIEDs action handler.
//
// Parameters:
//   0: Person detonating his VBIEDs.
//   1: Person detonating his VBIEDs.
//   2: Action index.
//
// Returns:
//   nil
//
// -----------------------------------------------------------------------------

#include "debug.inc.sqf"
#include "macros.inc.sqf"
#include "ieds.inc.sqf"

// -----------------------------------------------------------------------------

SPON_GET_PARAMS_3(_actionObject,_bomber,_action);

// Can't detonate using this action again!
_actionObject removeAction _action;

// If we detonated our bombs whilst in the vehicle, remove the
// "detonate" action from ourself as well.
if (SPON_IN_VEHICLE(_bomber)) then
{
	private ["_action"];
	_action = _bomber getVariable DETONATE_VBIED_ON_FOOT_ACTION_VAR;
	if (not (isNil "_action")) then
	{
		_bomber removeAction _action;
		_bomber setVariable [DETONATE_VBIED_ON_FOOT_ACTION_VAR, nil];
	};
	
	_bomber setVariable [DETONATE_VBIED_IN_VEHICLE_ACTION_VAR, nil];
}
else
{
	_bomber setVariable [DETONATE_VBIED_ON_FOOT_ACTION_VAR, nil];
};

private ["_i", "_vbiedsAttachedTo"];
_vbiedsAttachedTo = _bomber getVariable VBIEDS_ATTACHED_TO_VAR;

// Tell the vehicles to explode.
for "_i" from 0 to ((count _vbiedsAttachedTo) - 1) do
{
	private ["_vehicle", "_var"];
	
	_var = format ["SPON_vbiedDetonatedIn_%1", _i];
	_vehicle = _vbiedsAttachedTo select _i;
	
	call compile format ["%1 = _vehicle", _var];
	publicVariable _var;
	
	SPON_TRACE_2("Preparing to detonate vehicle",_var,call compile _var);
	
	// Remove the disarm action immediately.
	[_vehicle] call SPON_removeVBIEDAction;
};

SPON_TRACE_1("Detonating vehicles",count _vbiedsAttachedTo);
[VBIED_DETONATED_EVENT, [count _vbiedsAttachedTo]] call SPON_publishGlobalEvent;

_bomber setVariable [VBIEDS_ATTACHED_TO_VAR, nil];

nil; // Return.

