// -----------------------------------------------------------------------------
#define SPON_THIS_FILE SPON\VBIED\disarmVBIEDAction
//
// Copyright (C) 2007 Bil Bas (bil.bagpuss@gmail.com \ Spooner)
// License: GNU General Public License, version 3 <http://www.gnu.org/licenses/>
//
// Last Modified: $Date: 2007/09/21 21:22:46 $
//
// Description:
//   Disarm VBIED action handler.
//
// Parameters:
//   0: Vehicle VBIED being removed from.
//   1: Person setting the VBIED.
//   2: Action index.
//   3: Params (none passed, so ignored).
//
// Returns:
//   nil
//
// -----------------------------------------------------------------------------

#include "debug.inc.sqf"
#include "macros.inc.sqf"
#include "ieds.inc.sqf"

// -----------------------------------------------------------------------------

SPON_GET_PARAMS_3(_vehicle,_bomber,_action);

if (not (isPlayer _bomber)) exitWith
{
	titleText [localize "STR_SPON_VBIED_CANT_USE_AI", "PLAIN DOWN"];
};
	
// TODO: Double-check that the player can CARRY the satchel.
private ["_name"];
	
_name = [_vehicle] call SPON_vbiedGetVehicleName;
	
if ((_bomber distance _vehicle) < VBIED_PLACEMENT_RANGE) then
{
	call SPON_vbiedAnimation;
	
	_bomber addMagazine SPON_vbiedMagazineClass;
	
	// Remove the detonate label and add the correct one (if still needed).
	_bomber removeAction (_bomber getVariable DETONATE_VBIED_ON_FOOT_ACTION_VAR);
	
	// Remember which vehicle the bomber has already bombed.
	_vbiedsAttachedTo = _bomber getVariable VBIEDS_ATTACHED_TO_VAR;
	_vbiedsAttachedTo = _vbiedsAttachedTo - [_vehicle];
	_bomber setVariable [VBIEDS_ATTACHED_TO_VAR, _vbiedsAttachedTo];
	
	private ["_newAction"];
	if ((count _vbiedsAttachedTo) > 0) then
	{
		private ["_label"];
		if ((count _vbiedsAttachedTo) > 1) then
		{
			_label = format [localize "STR_SPON_VBIED_DETONATE_MULTIPLE_ACTION",
				count _vbiedsAttachedTo];
		}
		else
		{	
			_label = localize "STR_SPON_VBIED_DETONATE_SINGLE_ACTION";
		};
		
		_newAction = _bomber addAction [_label, DETONATE_VBIED_ACTION_FILE];
		_bomber setVariable [DETONATE_VBIED_ON_FOOT_ACTION_VAR, _newAction];
	}
	else // No more VBIEDS.
	{
		_bomber setVariable [DETONATE_VBIED_ON_FOOT_ACTION_VAR, nil];
	};
	
	// Replace "disarm" action with "place".
	_vehicle removeAction _action;
	_vehicle setVariable [DISARM_VBIED_ACTION_VAR, nil];
	
	_newAction = _vehicle addAction [
			format [localize "STR_SPON_VBIED_SET_ACTION", _name],
			SET_VBIED_ACTION_FILE];
	_vehicle setVariable [SET_VBIED_ACTION_VAR, _newAction];
}
else // Too far from vehicle.
{
	titleText [format [localize "STR_SPON_VBIED_CANT_DISARM_DISTANCE", _name],
		"PLAIN DOWN"];
};

nil; // Return.