// -----------------------------------------------------------------------------
// Common include file for SPON\VBIED
//
// Copyright (C) 2007 Bil Bas (bil.bagpuss@gmail.com \ Spooner)
// License: GNU General Public License, version 3 <http://www.gnu.org/licenses/>
//
// Last Modified: $Date: 2007/10/01 17:38:54 $
//
// -----------------------------------------------------------------------------
// Setting a VBIED
#define SET_VBIED_ACTION_FILE "SPON\VBIED\setVBIEDAction.sqf"
#define SET_VBIED_ACTION_VAR "SPON_setVBIEDAction"

// Although actions work to about 5 m away from the edge of the vehicle, we'd
// rather limit that (to a small distance from the CENTRE of the vehicle).
#define VBIED_PLACEMENT_RANGE 4.5

// Disabling a VBIED
#define DISARM_VBIED_ACTION_FILE "SPON\VBIED\disarmVBIEDAction.sqf"
#define DISARM_VBIED_ACTION_VAR "SPON_disarmVBIEDAction"

#define TIME_TO_PLACE_VBIED 2

// Detonating a VBIED
#define DETONATE_VBIED_ON_FOOT_ACTION_VAR "SPON_detonateVBIEDOutsideAction"
#define DETONATE_VBIED_IN_VEHICLE_ACTION_VAR "SPON_detonateVBIEDInsideAction"
#define DETONATE_VBIED_ACTION_FILE "SPON\VBIED\detonateVBIEDAction.sqf"

// Variables
#define VBIEDS_ATTACHED_TO_VAR "SPON_vbiedsAttachedTo"

#define VBIED_DETONATED_EVENT "SPON_vbiedsDetonated"

// Animations
#define ANIMATION_FROM_STAND  "amovpercmstpsraswrfldnon_ainvpknlmstpslaywrfldnon"
#define ANIMATION_FROM_CROUCH "amovpknlmstpsraswrfldnon_ainvpknlmstpslaywrfldnon"

#define MANDO_GETPOS_STAND 0
#define MANDO_GETPOS_CROUCH 1
#define MANDO_GETPOS_PRONE 2
#define MANDO_GETPOS_UNKNOWN -1 

// Time between polling if someone has VBIEDs
#define HAS_VBIED_DELAY 5

// Time between polling if someone has no VBIEDs any more
#define HAS_NO_VBIED_DELAY 0.5

#define DEFAULT_MAGAZINE_CLASS "PipeBomb"                        