// -----------------------------------------------------------------------------
#define SPON_THIS_FILE SPON\VBIED\setVBIEDAction
//
// Copyright (C) 2007 Bil Bas (bil.bagpuss@gmail.com \ Spooner)
// License: GNU General Public License, version 3 <http://www.gnu.org/licenses/>
//
// Last Modified: $Date: 2007/09/21 21:22:46 $
//
// Description:
//   Set VBIED action handler.
//
// Parameters:
//   0: Vehicle VBIED being placed on.
//   1: Person setting the VBIED.
//   2: Action index.
//   3: Params (none passed, so ignored).
//
// Returns:
//   nil
//
// -----------------------------------------------------------------------------

#include "debug.inc.sqf"
#include "macros.inc.sqf"
#include "ieds.inc.sqf"

// -----------------------------------------------------------------------------

SPON_GET_PARAMS_3(_vehicle,_bomber,_action);

// Double-check that the player still has an explosive. If not, then the action
// was just about to be removed anyway (so ignore).
if (SPON_vbiedMagazineClass in (magazines _bomber)) then
{
	if (not (isPlayer _bomber)) exitWith
	{
		titleText [localize "STR_SPON_VBIED_CANT_USE_AI", "PLAIN DOWN"];
	};
	
	private ["_name"];
		
	_name = [_vehicle] call SPON_vbiedGetVehicleName;
		
	if ((_bomber distance _vehicle) < VBIED_PLACEMENT_RANGE) then
	{
		call SPON_vbiedAnimation;
		
		_bomber removeMagazine SPON_vbiedMagazineClass;
		
		// Remember which vehicle the bomber has already bombed.
		_vbiedsAttachedTo = _bomber getVariable VBIEDS_ATTACHED_TO_VAR;
		if (isNil "_vbiedsAttachedTo") then
		{
			_vbiedsAttachedTo = [];
		};
		
		SPON_PUSH(_vbiedsAttachedTo, _vehicle);
		_bomber setVariable [VBIEDS_ATTACHED_TO_VAR, _vbiedsAttachedTo];
	
		private ["_label", "_newAction"];
		if ((count _vbiedsAttachedTo) > 1) then
		{
			// Remove the old detonate action and replace it.
			_bomber removeAction (_bomber getVariable DETONATE_VBIED_ON_FOOT_ACTION_VAR);
			_label = format [localize "STR_SPON_VBIED_DETONATE_MULTIPLE_ACTION",
				count _vbiedsAttachedTo];
		}
		else
		{
			_label = localize "STR_SPON_VBIED_DETONATE_SINGLE_ACTION";
		};
			
		_newAction = _bomber addAction [_label, DETONATE_VBIED_ACTION_FILE];
		_bomber setVariable [DETONATE_VBIED_ON_FOOT_ACTION_VAR, _newAction];
		
		// Replace "place" action with "disarm".
		_vehicle removeAction _action;
		_vehicle setVariable [SET_VBIED_ACTION_VAR, nil];
		
		_newAction = _vehicle addAction [
				format [localize "STR_SPON_VBIED_DISARM_ACTION", _name],
				DISARM_VBIED_ACTION_FILE];
		_vehicle setVariable [DISARM_VBIED_ACTION_VAR, _newAction];
	}
	else // Too far from vehicle.
	{
		titleText [format [localize "STR_SPON_VBIED_CANT_PLACE_DISTANCE", _name],
			"PLAIN DOWN"];
	};
};

nil; // Return.