/*******************************************************************************
							 --- TimeXleration ---
									  v1.0

	Author      : gammadust (GAM)

	Additional  : - BIS for the awesome sandbox 
	Credits		  - Whole community for the help given in learning ArmA
					scripting and making the ArmA experience even better

	Features    : Allows to accelerate the in-game time maintaining the rest of
				  the simulation acceleration intact

	Installation: From "mission_scripts" folder, copy both "init.sqf" and
	(as mission)  "timexleration.sqf" scripts into your mission folder,
	   script	  alternatively, add the following line in your pre-existing
				  "init.sqf" in a suitable place
				  
		[] spawn compile preprocessFileLineNumbers "timexleration.sqf";
		
		Defaults to 60 times normal acceleration at ~33,3 updates per second
		
		Optionaly insert acceleration and updates per second values between
		the square brackets:
				  
		[60,100/3] spawn compile preprocessFileLineNumbers "timexleration.sqf";

*******************************************************************************/
_acceleration = 60; // Default - acceleration factor
_updaterate = 100 / 3; // Default - updates per second - recommended value for smooth update = 100/3 (ties with 33,3fps)
switch (count _this) do {
	case 1: {
		_acceleration = _this select 0;
	};
	case 2:	{
		_acceleration = _this select 0;
		_updaterate = _this select 1;
	};
};
_tick = 1 / _updaterate; // time in seconds between updates
_tepf = 1 / 3600 / _updaterate; // time elapsed per tick (in hours)
_timetoskip = (_acceleration * _tepf) - (_tepf); // subtract also time actually elapsed since last tick
while {true} do {
	skipTime (_timetoskip);
	sleep _tick;
}