#define ASR_GRASS_CUT_COEF_Chernarus 0.85
#define ASR_GRASS_CUT_COEF_Utes 0.9

class CfgWorlds {
	class DefaultWorld;
	class CAWorld : DefaultWorld {
		class DefaultClutter;
	};

	class Chernarus : CAWorld {
		class clutter {
			class GrassTall : DefaultClutter {
				scaleMin = 0.7 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.0 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class StubbleClutter : DefaultClutter {
				scaleMin = 0.9 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.1 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class AutumnFlowers : DefaultClutter {
				scaleMin = 0.7 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.0 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class GrassBunch : DefaultClutter {
				scaleMin = 0.6 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.0 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class GrassCrooked : DefaultClutter {
				scaleMin = 0.7 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.4 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class GrassCrookedGreen : DefaultClutter {
				scaleMin = 0.9 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.3 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class GrassCrookedForest : DefaultClutter {
				scaleMin = 0.8 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.4 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class WeedDead : DefaultClutter {
				scaleMin = 0.75 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.1 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class WeedDeadSmall : DefaultClutter {
				scaleMin = 0.75 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 0.9 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class HeatherBrush : DefaultClutter {
				scaleMin = 0.9 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.8 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class WeedSedge : DefaultClutter {
				scaleMin = 0.5 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 0.85 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class WeedTall : DefaultClutter {
				scaleMin = 0.8 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.1 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class BlueBerry : DefaultClutter {
				scaleMin = 0.85 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.3 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class RaspBerry : DefaultClutter {
				scaleMin = 0.8 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.2 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class FernAutumn : DefaultClutter {
				scaleMin = 0.6 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.2 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class FernAutumnTall : DefaultClutter {
				scaleMin = 0.75 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.0 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class SmallPicea : DefaultClutter {
				scaleMin = 0.75 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.25 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class PlantWideLeaf : DefaultClutter {
				scaleMin = 1.0 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.0 *ASR_GRASS_CUT_COEF_Chernarus;
			};
			
			class MushroomsHorcak : DefaultClutter {
				scaleMin = 0.85 *ASR_GRASS_CUT_COEF_Chernarus;
				scaleMax = 1.25 *ASR_GRASS_CUT_COEF_Chernarus;
			};
		};
	};

	class utes : CAWorld {
		class Clutter {
			class UTGrassDryBunch : DefaultClutter {
				scaleMin = 0.5 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 1.0 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class UTGrassDryLongBunch : DefaultClutter {
				scaleMin = 0.6 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 1.1 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class UTAutumnFlowers : DefaultClutter {
				scaleMin = 0.7 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 1.0 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class UTHeatherBrush : DefaultClutter {
				scaleMin = 0.8 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 1.8 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class UTWeedSedge : DefaultClutter {
				scaleMin = 0.5 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 0.85 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class UTWeedTall : DefaultClutter {
				scaleMin = 0.8 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 1.1 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class UTWeedDead : DefaultClutter {
				scaleMin = 0.75 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 1.1 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class UTWeedDeadSmall : DefaultClutter {
				scaleMin = 0.75 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 0.9 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class UTBlueBerry : DefaultClutter {
				scaleMin = 0.85 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 1.3 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class UTFernAutumn : DefaultClutter {
				scaleMin = 0.6 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 1.2 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class UTFernAutumnTall : DefaultClutter {
				scaleMin = 0.75 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 1.0 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class GrassCrookedForest : DefaultClutter {
				scaleMin = 0.8 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 1.4 *ASR_GRASS_CUT_COEF_Utes;
			};
			
			class UTMushroomsPrasivka : DefaultClutter {
				scaleMin = 0.85 *ASR_GRASS_CUT_COEF_Utes;
				scaleMax = 1.25 *ASR_GRASS_CUT_COEF_Utes;
			};
		};
	};
};
