/************************************
Script to deploy a vehicle camo net at the location of the soldier.  
Modfied from sxp2high's example posted in BIS forums :)


Instructions:
==============

1. Add this to the vehicle's init line in the editor:

this setVariable ["vehicle_camonetDeployed", false, true]; 
this addAction ["Deploy Camo Net", "camonetvehicle.sqf", ["Deploy"], 51, false, true, "", "!(_target getVariable 'vehicle_camonetDeployed')"]; 
this addAction ["Stow Camo Net", "camonetvehicle.sqf", ["Stow"], 50, false, true, "", "(_target getVariable 'vehicle_camonetDeployed')"];


2. Edit the THREE (3) lines marked in the script below with 
any other type of net you desire.  Use the net types listed.

3. Save and copy this script into the mission folder.

************************************/

/************************************
Net Types:

Net Numbers:

The numbers represent the camo type (0-22):
(no number) = BIS Chernarus Camo (East Pattern) / BIS Nato Green (West Pattern)
2.  BIS Desert Brown (East Pattern) / BIS Nato Tan (West Pattern)
3.  CADPAT
4.  Desert Storm
5.  DPM Desert
6.  Flecktarn
7.  Flecktarn Desert
8.  Rus Desert Camo
9.  Rus Forest Camo
10. AOR Forest
11. ATACS Desert
12. ATACS Forest
13. DPM Forest
14. MARPAT
15. Multicam
16. Snow
17. Spec
18. SURPAT
19. Woodland
20. Nogovan Oak
21. Duala Brown
22. Lingor Jungle


----------------------------
Medium Vehicle (M113 sized):
----------------------------
pook_camonet_vehmed_east  
pook_camonet_vehmed_west

----------------------------
Large Vehicle (Tank sized):
----------------------------
pook_camonet_vehtank_east
pook_camonet_vehtank_west

------------------------------
X-Large Vehicle (Truck sized):
------------------------------
pook_camonet_vehtruck_east
pook_camonet_vehtruck_west

------------------------------
Helicopter Nets:
------------------------------
pook_camonet_airheloAH1_east
pook_camonet_airheloAH1_west

pook_camonet_airheloKA52_east
pook_camonet_airheloKA52_west

pook_camonet_airheloMi17_east
pook_camonet_airheloMi17_west

pook_camonet_airheloMi24_east
pook_camonet_airheloMi24_west

pook_camonet_airheloMV22_east
pook_camonet_airheloMV22_west

pook_camonet_airheloUH60_east
pook_camonet_airheloUH60_west

------------------------------
Airplane Nets:
------------------------------
pook_camonet_airplaneA10_east
pook_camonet_airplaneA10_west

pook_camonet_airplaneAV8_east
pook_camonet_airplaneAV8_west

pook_camonet_airplaneSu25_east
pook_camonet_airplaneSu25_west

pook_camonet_airplaneSu34_east
pook_camonet_airplaneSu34_west


************************************/

if (isDedicated) exitWith {}; 

_vehicle = _this select 0;
_man = _this select 1;

_option = (_this select 3) select 0; 

if (_man != player) exitWith {}; 


if (_option == "Deploy") exitWith {


    if (vehicle _man != player) then { 
        hint "You must exit the vehicle first."; 
    } else {
		_man playMove "ActsPercSnonWnonDnon_carFixing2";
		sleep 30;
		_vehicle_camonetMarker = "HeliHEmpty" createVehicle [0,0,0]; 
		_vehicle_camonetMarker setPos [ getPos _vehicle select 0, getPos _vehicle select 1, 0];
		sleep 1;
///////////////////////////////////////////////////
// Edit this line (1 of 3) for different nets!!!
		_vehicle_camonet = "pook_camonet_vehtank_east" createVehicle [0,0,0]; 
///////////////////////////////////////////////////
		_vehicle_camonet setDir (getDir _vehicle);
		_vehicle_camonet setPos [ getPos _vehicle select 0, getPos _vehicle select 1, 0];
		sleep 1;
	
		_vehicle setVariable ["vehicle_camonetDeployed", true, true]; 
		sleep 1;


	waitUntil {!(_vehicle getVariable "vehicle_camonetDeployed") || (_vehicle distance _vehicle_camonetMarker > 25) || !(alive _vehicle)};
    
    if (!(_vehicle getVariable "vehicle_camonetDeployed")) exitWith {};

		_vehicle setVariable ["vehicle_camonetDeployed", false, true]; 
		sleep 1;
///////////////////////////////////////////////////
// Edit this line (2 of 3) for different nets!!!
		_vehicle_camonet = nearestObject [_vehicle, "pook_camonet_vehtank_east"];
///////////////////////////////////////////////////
		deleteVehicle _vehicle_camonet;
		sleep 1;
		_vehicle_camonetMarker = nearestObject [_vehicle, "HeliHEmpty"]; 
		deleteVehicle _vehicle_camonetMarker;
		sleep 1;
	};
};


if (_option == "Stow") exitWith { 

    if (vehicle _man != player) then { 
        hint "You must exit the vehicle first.";
    } else { 
     
        _man playMove "ActsPercSnonWnonDnon_carFixing2"; 
		sleep 30;
///////////////////////////////////////////////////
// Edit this line (3 of 3) for different nets!!!
		_vehicle_camonet = nearestObject [_vehicle, "pook_camonet_vehtank_east"];
///////////////////////////////////////////////////
		deleteVehicle _vehicle_camonet;
		sleep 1;
		_vehicle_camonetMarker = nearestObject [_vehicle, "HeliHEmpty"]; 
		deleteVehicle _vehicle_camonetMarker;
		sleep 1;

    _vehicle setVariable ["vehicle_camonetDeployed", false, true]; 
	
    }; 
};  

