#define ReadAndWrite		0
#define ReadAndCreate		1
#define ReadOnly		2
#define ReadOnlyVerified		3

#define VSoft		0
#define VArmor		1
#define VAir		2

#define TEast		0
#define TWest		1
#define TGuerrila		2
#define TCivilian		3
#define TSideUnknown		4
#define TEnemy		5
#define TFriendly		6
#define TLogic		7

class CfgPatches {
	class samplemap2 {
		units[] = {"samplemap2"};
		weapons[] = {};
		requiredVersion = 0.1;
		requiredAddons[] = {};
	};
};

class CfgVehicles {};

class CfgWorlds {
	class DefaultWorld {
		class Weather;	// External class reference
	};
	
	class CAWorld : DefaultWorld {
		class Grid {};
		class DayLightingBrightAlmost;	// External class reference
		class DayLightingRainy;	// External class reference
		class DefaultClutter;	// External class reference
		
		class Weather : Weather {
			class Lighting;	// External class reference
		};
	};
	class DefaultLighting;	// External class reference
	
	class samplemap2 : CAWorld {
		access = ReadOnlyVerified;
		worldId = 4;
		cutscenes[] = {};
		description = "Sample Map 2";
		icon = "";
		worldName = "\SampleMap2\samplemap2.wrp";
		pictureMap = "";
		pictureShot = "";
		plateFormat = "ML$ - #####";
		plateLetters = ABCDEGHIKLMNOPRSTVXZ;
		longitude = -40;	// positive is east
		latitude = -40;	// positive is south
		
		class Grid : Grid {
			offsetX = 0;
			offsetY = 0;
			
			class Zoom1 {
				zoomMax = 0.15;
				format = "XY";
				formatX = 000;
				formatY = 000;
				stepX = 100;
				stepY = 100;
			};
			
			class Zoom2 {
				zoomMax = 0.85;
				format = "XY";
				formatX = "00";
				formatY = "00";
				stepX = 1000;
				stepY = 1000;
			};
			
			class Zoom3 {
				zoomMax = 1e+030;
				format = "XY";
				formatX = "0";
				formatY = "0";
				stepX = 10000;
				stepY = 10000;
			};
		};
		startTime = 14:20;
		startDate = 11/10/2008;
		startWeather = 0.4;
		startFog = 0.0;
		forecastWeather = 0.25;
		forecastFog = 0.0;
		centerPosition[] = {3500, 3500, 300};
		seagullPos[] = {2560, 150, 2560};
		ilsPosition[] ={2545,3000};
		ilsDirection[] ={0,0.08,1};
		ilsTaxiIn[]= {2495,2725, 2495,2850,  2508,2860, 2508,3000, 2520,3010, 2545,3000};
		ilsTaxiOff[]= {2545,2445,2520,2425,2495,2445,2495,2725};
		drawTaxiway=false;
			
		class ReplaceObjects {};
		
		class Sounds {
			sounds[] = {};
		};
		
		class Animation {
			vehicles[] = {};
		};
		
		class Lighting : DefaultLighting {
			groundReflection[] = {0.06, 0.06, 0.03};
		};
		
		class DayLightingBrightAlmost : DayLightingBrightAlmost {
			deepNight[] = {-15, {0.05, 0.05, 0.06}, {0.001, 0.001, 0.002}, {0.02, 0.02, 0.05}, {0.003, 0.003, 0.003}, {0.0001, 0.0001, 0.0002}, {0.0001, 0.0001, 0.0002}, 0};
			fullNight[] = {-5, {0.05, 0.05, 0.05}, {0.02, 0.02, 0.02}, {0.04, 0.04, 0.04}, {0.04, 0.04, 0.04}, {0.01, 0.01, 0.02}, {0.08, 0.06, 0.06}, 0};
			sunMoon[] = {-3.75, {0.045, 0.04, 0.04}, {0.04, 0.04, 0.04}, {0.045, 0.04, 0.04}, {0.04, 0.04, 0.04}, {0.04, 0.035, 0.04}, {0.1, 0.08, 0.09}, 0.5};
			earlySun[] = {-2.5, {0.12, 0.1, 0.1}, {0.08, 0.06, 0.07}, {0.12, 0.1, 0.1}, {0.08, 0.06, 0.07}, {0.08, 0.07, 0.08}, {0.1, 0.1, 0.12}, 1};
			sunrise[] = {0, {{0.7, 0.45, 0.45}, 5.16+(-4)}, {{0.07, 0.09, 0.12}, 4.0+(-4)}, {{0.6, 0.47, 0.25}, 4.66+(-4)}, {{0.1, 0.09, 0.1}, 4.3+(-4)}, {{0.5, 0.4, 0.4}, 6.49+(-4)}, {{0.88, 0.51, 0.24}, 8.39+(-4)}, 1};
			earlyMorning[] = {3, {{0.65, 0.55, 0.55}, 6.04+(-4)}, {{0.08, 0.09, 0.11}, 4.5+(-4)}, {{0.55, 0.47, 0.25}, 5.54+(-4)}, {{0.1, 0.09, 0.1}, 5.02+(-4)}, {{0.5, 0.4, 0.4}, 7.05+(-4)}, {{0.88, 0.51, 0.24}, 8.88+(-4)}, 1};
			midMorning[] = {8, {{0.98, 0.85, 0.8}, 8.37+(-4)}, {{0.08, 0.09, 0.11}, 6.42+(-4)}, {{0.87, 0.47, 0.25}, 7.87+(-4)}, {{0.09, 0.09, 0.1}, 6.89+(-4)}, {{0.5, 0.4, 0.4}, 8.9+(-4)}, {{0.88, 0.51, 0.24}, 10.88+(-4)}, 1};
			morning[] = {16, {{1, 1, 0.9}, 13.17+(-4)}, {{0.17, 0.18, 0.19}, 10.26+(-4)}, {{1, 1, 0.9}, 12.67+(-4)}, {{0.17, 0.18, 0.19}, 11.71+(-4)}, {{0.15, 0.15, 0.15}, 12.42+(-4)}, {{0.17, 0.17, 0.15}, 14.42+(-4)}, 1};
			noon[] = {45, {{1, 1, 1}, 17+(-4)}, {{1, 1.3, 1.55}, 13.5+(-4)}, {{1, 1, 1}, 15+(-4)}, {{0.36, 0.37, 0.38}, 13.5+(-4)}, {{1, 1, 1}, 16+(-4)}, {{1.0, 1.0, 1}, 17+(-4)}, 1};
		};
		
		class DayLightingRainy : DayLightingRainy {
			deepNight[] = {-15, {0.0034, 0.0034, 0.004}, {0.003, 0.003, 0.003}, {0.0034, 0.0034, 0.004}, {0.003, 0.003, 0.003}, {0.001, 0.001, 0.002}, {0.001, 0.001, 0.002}, 0};
			fullNight[] = {-5, {0.023, 0.023, 0.023}, {0.02, 0.02, 0.02}, {0.023, 0.023, 0.023}, {0.02, 0.02, 0.02}, {0.01, 0.01, 0.02}, {0.08, 0.06, 0.06}, 0};
			sunMoon[] = {-3.75, {0.04, 0.04, 0.05}, {0.04, 0.04, 0.05}, {0.04, 0.04, 0.05}, {0.04, 0.04, 0.05}, {0.04, 0.035, 0.04}, {0.11, 0.08, 0.09}, 0.5};
			earlySun[] = {-2.5, {0.0689, 0.0689, 0.0804}, {0.06, 0.06, 0.07}, {0.0689, 0.0689, 0.0804}, {0.06, 0.06, 0.07}, {0.08, 0.07, 0.08}, {0.14, 0.1, 0.12}, 0.5};
			earlyMorning[] = {0, {{1, 1, 1}, (-4)+3.95}, {{1, 1, 1}, (-4)+3.0}, {{1, 1, 1}, (-4)+3.95}, {{1, 1, 1}, (-4)+3.0}, {{1, 1, 1}, (-4)+4}, {{1, 1, 1}, (-4)+5.5}, 1};
			morning[] = {5, {{1, 1, 1}, (-4)+5.7}, {{1, 1, 1}, (-4)+4.5}, {{1, 1, 1}, (-4)+5.7}, {{1, 1, 1}, (-4)+4.5}, {{1, 1, 1}, (-4)+7}, {{1, 1, 1}, (-4)+8}, 1};
			lateMorning[] = {25, {{1, 1, 1}, (-4)+10.45}, {{1, 1, 1}, (-4)+9.75}, {{1, 1, 1}, (-4)+10.45}, {{1, 1, 1}, (-4)+9.75}, {{1, 1, 1}, (-4)+12}, {{1, 1, 1}, (-4)+12.75}, 1};
			noon[] = {70, {{1, 1, 1}, (-4)+12.5}, {{1, 1, 1}, (-4)+11}, {{1, 1, 1}, (-4)+12}, {{1, 1, 1}, (-4)+11}, {{1, 1, 1}, (-4)+13.5}, {{1, 1, 1}, (-4)+14}, 1};
		};
		
		class Weather : Weather {
			class Lighting : Lighting {
				class BrightAlmost : DayLightingBrightAlmost {
					overcast = 0;
				};
				
				class Rainy : DayLightingRainy {
					overcast = 1.0;
				};
			};
		};
		clutterGrid = 1.0;
		clutterDist = 200;
		noDetailDist = 40;
		fullDetailDist = 15;
		midDetailTexture = "SampleMap2\data\ut_middle_mco.paa";
		minTreesInForestSquare = 5;
		minRocksInRockSquare = 4;
		
		class Clutter {
			class UTGrassDryBunch : DefaultClutter {
				model = "ca\plants2\clutter\c_deadGrassBunch.p3d";
				affectedByWind = 0.35;
				swLighting = 1;
				scaleMin = 0.4;
				scaleMax = 0.7;
			};
			
			class UTGrassDryLongBunch : DefaultClutter {
				model = "ca\plants2\clutter\c_grassDryLongBunch.p3d";
				affectedByWind = 0.35;
				swLighting = 1;
				scaleMin = 0.6;
				scaleMax = 1.1;
			};
			
			class UTAutumnFlowers : DefaultClutter {
				model = "ca\plants2\clutter\c_autumn_flowers.p3d";
				affectedByWind = 0.4;
				swLighting = 1;
				scaleMin = 0.7;
				scaleMax = 1.0;
			};
			
			class UTHeatherBrush : DefaultClutter {
				model = "ca\plants2\clutter\c_caluna.p3d";
				affectedByWind = 0.15;
				swLighting = 1;
				scaleMin = 0.8;
				scaleMax = 1.8;
			};
			
			class UTWeedSedge : DefaultClutter {
				model = "ca\plants2\clutter\c_weed3.p3d";
				affectedByWind = 0.2;
				swLighting = 1;
				scaleMin = 0.5;
				scaleMax = 0.85;
			};
			
			class UTWeedTall : DefaultClutter {
				model = "ca\plants2\clutter\c_weed2.p3d";
				affectedByWind = 0.3;
				swLighting = 1;
				scaleMin = 0.8;
				scaleMax = 1.1;
			};
			
			class UTWeedDead : DefaultClutter {
				model = "ca\plants2\clutter\c_WeedDead.p3d";
				affectedByWind = 0.3;
				swLighting = 1;
				scaleMin = 0.75;
				scaleMax = 1.1;
			};
			
			class UTWeedDeadSmall : DefaultClutter {
				model = "ca\plants2\clutter\c_WeedDead2.p3d";
				affectedByWind = 0.3;
				swLighting = 1;
				scaleMin = 0.75;
				scaleMax = 0.9;
			};
			
			class UTBlueBerry : DefaultClutter {
				model = "ca\plants2\clutter\c_BlueBerry.p3d";
				affectedByWind = 0.05;
				swLighting = 1;
				scaleMin = 0.85;
				scaleMax = 1.3;
			};
			
			class UTFernAutumn : DefaultClutter {
				model = "ca\plants2\clutter\c_fern.p3d";
				affectedByWind = 0.1;
				scaleMin = 0.6;
				scaleMax = 1.2;
			};
			
			class UTFernAutumnTall : DefaultClutter {
				model = "ca\plants2\clutter\c_fernTall.p3d";
				affectedByWind = 0.15;
				scaleMin = 0.75;
				scaleMax = 1.0;
			};
			
			class GrassCrookedForest : DefaultClutter {
				model = "ca\plants2\clutter\c_GrassCrookedForest.p3d";
				affectedByWind = 0.3;
				swLighting = 1;
				scaleMin = 0.8;
				scaleMax = 1.4;
			};
			
			class UTMushroomsPrasivka : DefaultClutter {
				model = "ca\plants2\clutter\c_MushroomPrasivky.p3d";
				affectedByWind = 0;
				scaleMin = 0.85;
				scaleMax = 1.25;
			};

//These definitions are from Chernarus
			class GrassCrooked : DefaultClutter {
				model = "ca\plants2\clutter\c_GrassCrooked.p3d";
				affectedByWind = 0.3;
				swLighting = 1;
				scaleMin = 0.2;
				scaleMax = 0.5;
			};
			
			class GrassCrookedGreen : DefaultClutter {
				model = "ca\plants2\clutter\c_GrassCrookedGreen.p3d";
				affectedByWind = 0.3;
				swLighting = 1;
				scaleMin = 0.3;
				scaleMax = 0.6;
			};
		};
		
		class Subdivision {
			class Fractal {
				rougness = 5;
				maxRoad = 0.02;
				maxTrack = 0.5;
				maxSlopeFactor = 0.05;
			};
			
			class WhiteNoise {
				rougness = 2;
				maxRoad = 0.01;
				maxTrack = 0.05;
				maxSlopeFactor = 0.0025;
			};
			minY = 0.0;
			minSlope = 0.02;
		};
		
		class Ambient {
			class Mammals {
				radius = 200;
				cost = "(1 + forest + trees) * (0.5 + (0.5 * night)) * (1 - sea) * (1 - houses)";
				
				class Species {
					class Rabbit {
						probability = 0.2;
						cost = 1;
					};
				};
			};
			
			class BigBirds {
				radius = 300;
				cost = "((1 + forest + trees) - ((2 * rain)) - houses) * (1 - night) * (1 - sea)";
				
				class Species {
					class Hawk {
						probability = 0.2;
						cost = 1;
					};
				};
			};
			
			class Birds {
				radius = 170;
				cost = "(1 - night) * ((1 + (3 * sea)) - (2 * rain))";
				
				class Species {
					class Crow {
						probability = 0.2;
						cost = 1;
					};
				};
			};
			
			class BigInsects {
				radius = 20;
				cost = "(5 - (2 * houses)) * (1 - night) * (1 - rain) * (1 - sea) * (1 - windy)";
				
				class Species {
					class DragonFly {
						probability = "0.6 - (meadow * 0.5) + (forest * 0.4)";
						cost = 1;
					};
					
					class ButterFly {
						probability = "0.4 + (meadow * 0.5) - (forest * 0.4)";
						cost = 1;
					};
				};
			};
			
			class BigInsectsAquatic {
				radius = 20;
				cost = "(3 * sea) * (1 - night) * (1 - rain) * (1 - windy)";
				
				class Species {
					class DragonFly {
						probability = 1;
						cost = 1;
					};
				};
			};
			
			class SmallInsects {
				radius = 3;
				cost = "(12 - 8 * hills) * (1 - night) * (1 - rain) * (1 - sea) * (1 - windy)";
				
				class Species {
					class HouseFly {
						probability = "deadBody + (1 - deadBody) * (0.5 - forest * 0.1 - meadow * 0.2)";
						cost = 1;
					};
					
					class HoneyBee {
						probability = "(1 - deadBody) * (0.5 - forest * 0.1 + meadow * 0.2)";
						cost = 1;
					};
					
					class Mosquito {
						probability = "(1 - deadBody) * (0.2 * forest)";
						cost = 1;
					};
				};
			};
			
			class NightInsects {
				radius = 3;
				cost = "(9 - 8 * hills) * night * (1 - rain) * (1 - sea) * (1 - windy)";
				
				class Species {
					class Mosquito {
						probability = 1;
						cost = 1;
					};
				};
			};
			
			class WindClutter {
				radius = 10;
				cost = "((20 - 5 * rain) * (3 * (windy factor [0.2, 0.5]))) * (1 - sea)";
				
				class Species {
					class FxWindGrass1 {
						probability = "0.4 - 0.2 * hills - 0.2 * trees";
						cost = 1;
					};
					
					class FxWindGrass2 {
						probability = "0.4 - 0.2 * hills - 0.2 * trees";
						cost = 1;
					};
					
					class FxWindRock1 {
						probability = "0.4 * hills";
						cost = 1;
					};
				};
			};
			
			class NoWindClutter {
				radius = 15;
				cost = 8;
				
				class Species {
					class FxWindPollen1 {
						probability = 1;
						cost = 1;
					};
				};
			};
		};
		
		class Names {
			class Utes_Local_LHD {
				name = $STR_LOCATION_KHESANH;
				position[] = {1410.75, 1046.23};
				type = "NameLocal";
				radiusA = 100.0;
				radiusB = 100.0;
				angle = 0.0;
			};
			
			class Utes_VillKamenyy {
				name = $STR_LOCATION_KAMENYY;
				position[] = {3334.68, 4445.62};
				type = "NameVillage";
				speech[] = {"Kamenyy"};
				radiusA = 100.0;
				radiusB = 100.0;
				angle = 0.0;
			};					
		};
		
		class Armory {
		};
		safePositionAnchor[] = {3448.11, 3627.18};
		safePositionRadius = 2000;
	};
};

class CfgWorldList {
	class SampleMap2 {};
};

class CfgMissions {
};

class CfgSurfaces {
	class Default {};
	
	class Water {};
	
	class UTGravel : Default {
		access = ReadOnly;
		files = "";
		rough = 0.1;
		dust = 0.35;
		soundEnviron = "gravel";
		character = "Empty";
		soundHit = "hard_ground";
	};
	
	class UTRock : Default {
		access = ReadOnly;
		files = "";
		rough = 0.2;
		dust = 0.07;
		soundEnviron = "rock";
		character = "Empty";
		soundHit = "hard_ground";
	};
	
	class UTConcrete : Default {
		access = ReadOnly;
		files = "";
		rough = 0.08;
		dust = 0.05;
		soundEnviron = "concrete_ext";
		character = "Empty";
		soundHit = "hard_ground";
	};
	
	class UTBoulders : Default {
		access = ReadOnly;
		files = "";
		rough = 0.1;
		dust = 0.07;
		soundEnviron = "rock";
		character = "UTSparseGrassClutter";
		soundHit = "hard_ground";
	};
	
	class UTGround : Default {
		access = ReadOnly;
		files = "";
		rough = 0.1;
		dust = 0.2;
		soundEnviron = "dirt";
		character = "UTSparseGrassClutter";
		soundHit = "soft_ground";
	};
	
	class UTGrass : Default {
		access = ReadOnly;
		files = "cr_trava2_*";
		rough = 0.11;
		dust = 0.1;
		soundEnviron = "grass";
		character = "UTGrassClutter";
		soundHit = "soft_ground";
	};
	
	class UTHeather : Default {
		access = ReadOnly;
		files = "";
		rough = 0.14;
		dust = 0.1;
		soundEnviron = "drygrass";
		character = "UTHeatherClutter";
		soundHit = "soft_ground";
	};
	
	class UTWeeds : Default {
		access = ReadOnly;
		files = "";
		rough = 0.11;
		dust = 0.1;
		soundEnviron = "drygrass";
		character = "UTWeedsClutter";
		soundHit = "soft_ground";
	};
	
	class UTForest : Default {
		access = ReadOnly;
		files = "";
		rough = 0.2;
		dust = 0.15;
		soundEnviron = "forest";
		character = "UTPineForestClutter";
		soundHit = "soft_ground";
	};

	class CRGrassW1 : Default {
		access = ReadOnly;
		files = "cr_travad1_*";
		rough = 0.11;
		dust = 0.1;
		soundEnviron = "grass";
		character = "CRGrassWClutter";
		soundHit = "soft_ground";
	};
	

};

class CfgSurfaceCharacters {
	class UTSparseGrassClutter {
		names[] = {"UTGrassDryBunch"};
		probability[] = {0.07};
	};
	
	class UTGrassClutter {
		probability[] = {0.95, 0.02, 0.03};
		names[] = {"UTGrassDryBunch", "UTGrassDryLongBunch", "UTAutumnFlowers"};
	};
	
	class UTHeatherClutter {
		probability[] = {0.1, 0.25, 0.07, 0.03};
		names[] = {"UTBlueBerry", "UTHeatherBrush", "UTGrassDryBunch", "UTWeedSedge"};
	};
	
	class UTWeedsClutter {
		probability[] = {0.6, 0.3, 0.05, 0.03, 0.02};
		names[] = {"UTAutumnFlowers", "UTGrassDryLongBunch", "UTWeedTall", "UTWeedDead", "UTWeedDeadSmall"};
	};
	
	class UTPineForestClutter {
		probability[] = {0.1, 0.15, 0.2, 0.05, 0.001};
		names[] = {"UTBlueBerry", "UTFernAutumn", "UTFernAutumnTall", "UTGrassDryBunch", "UTMushroomsPrasivka"};
	};

	class CRGrassWClutter {
		probability[] = {1};
		names[] = {"GrassCrookedGreen"};
	};
};
