/*************************************************************
	BD Capture Scan Pattern
	Capture Scan Pattern

parameters:
 <unit>: object
 <duration>: number

call:
 [<unit>,<duration>] spawn BD_fnc_CaptureScanPattern

This function records weapon direction data similiar to the BIS
UnitCapture function. That is, when you call the function on a unit,
it will record where it is aiming so it can be played back. Recording
will stop after the passed duration, or when the user presses Escape,
at which point pressing F1 will copy the recorded data to the
clipboard. This data can then be used with the ScanPattern function.

This version uses an absolute pattern. That is, it will record exact
positions on the map. This is usefull for units that will move but
shall need to scan the same area wherever they are. Make sure you
play back the data using the absolute scanPattern function.
*************************************************************/

_unit = _this select 0;
_duration = _this select 1;
_timeStart = time;
_timeFinal = _timeStart + _duration;
_timeCur = time - _timeStart;
_capturedData = [];
_inputFPS = 20;

_timeOffset = 0;

hint format ["Starting Capture on %1...\n\nPress ESC to stop capture.",_unit];

_sleepTime = 1 / _inputFPS;

BD_EndCapture = false;
BD_ClipboardCopy_Pattern = false;

_FPS = 0;
_sleepDeficit = 0;
_sleepDeficitCheckLast = time;

disableSerialization;
_display = findDisplay 46;

// Stops Capture after pressing the ESC key
_display displaySetEventHandler ["KeyDown", "if ((_this select 1) == 1) then {BD_EndCapture = true};"];

while { ((time <= _timeFinal) && (alive _unit) && !(BD_EndCapture)) } do
{
	if (_FPS > 0) then
	{
		_sleepDeficit = (time - _sleepDeficitCheckLast) - (_sleepTime);
		_sleepDeficitCheckLast = time;
		if (_sleepDeficit < 0) then
		{
			_sleepDeficit = 0;
		}
	};

	_timeCur = time - _timeStart;

	_dir = _unit weaponDirection (currentWeapon _unit);
	_pos = getPosATL _unit;
	_scalar = 30;
	_lookPos = [_pos,([_dir,_scalar] call BIS_fnc_vectorMultiply)] call BIS_fnc_vectorAdd;
	
	_capturedData = _capturedData + [[(_timeCur + _timeOffset), _lookPos]];
	sleep (_sleepTime - _sleepDeficit);
	
	_FPS = _FPS + 1;
};

_timeCur = time - _timeStart;
_avgFPS = _FPS / _timeCur;
_avgSleepTime = (_timeCur - _timeStart) / _FPS;

hint format ["Capturing Completed\n----------------\n\nPress F1 to copy movement data to clipboard\n\nTotal captured frames:\n%1\n\nTotal capture time:\n%2\n----------------\n\nAvg. captured FPS:\n%3\n\nAvg. sleep time between frames:\n%4\n----------------\n\nInput FPS:\n%5\n\nInput sleep (from FPS):\n%6", _FPS, _timeCur, _avgFPS, _avgSleepTime, _inputFPS, _sleepTime];

// Copies data to clipboard after pressing the F1 key
_display displaySetEventHandler ["KeyDown", "if ((_this select 1) == 59) then {BD_ClipboardCopy_Pattern = true};"];

waitUntil {BD_ClipboardCopy_Pattern};

copyToClipBoard str _capturedData;

hint format ["Recorded Data copied to clipboard..."];