/*************************************************************
	BD Scan Pattern Relative
	Play Relative Scan Pattern

parameters:
 <scanningUnit>: object
 <capturedData>: array
 <looped>: boolean
 <ignoreEnemy> : boolean (optional)
 <additionalGuns> : array (optional)

call:
 [<scanningUnit>,<capturedData>,<looped>,(<ignoreEnemy>,<additionalGuns>)] spawn BD_fnc_ScanPatternRelative

Play captured scan data on the specified unit. If ignoreEnemy is not
set, then the unit will cease scanning when an enemy is detected,
and instead watch/target the enemy. When there are no more known
enemies near and the scan is looping, the unit will continue scanning.

If looped is set, when the unit completes the recorded scan, it will start
again from the beginning. For smoother loops, it is recommended that
when recording looped scans, that you end close to where you started.

Setting ingoreEnemy will disable the unit from reacting to enemys.
This means that they will continue the scan pattern regardless of
an enemy presence.

If an additionalGuns array is passed, these units will follow the target
unit's scan. For example, if you have a searchlight guiding a number of
AA guns, the AA guns will aim wherever the light is pointed.

This version uses a relative pattern. That is, the scanning path will
be adjusted to remain relative to the unit's position and direction.
This is suitable for when the target unit is moving and the scan
pattern shall be localized around the unit itself, or when you want
to use the same relative scan pattern regardless of the target unit's
position and direction compared to the unit it was recorded on.
Make sure you use data recorded with the relative capture function.
*************************************************************/

_targetUnit = _this select 0;
_capturedData = _this select 1;
_looped = _this select 2;
_ignoreEnemy = false;
if(count _this > 3)then{_ignoreEnemy = _this select 3};
_additionalGuns = [objNull];
if(count _this > 4)then{_additionalGuns = _this select 4};

_endSeq = false;
_suspendSeq = false;

_skipTime = 0;

if(_ignoreEnemy)then{_targetUnit disableAI "TARGET"; _targetUnit disableAI "AUTOTARGET"};

while{(alive _targetUnit) && ({alive _X} count (crew vehicle _targetUnit) > 0) && !(_endSeq)}do{

if(!(_ignoreEnemy) && (_suspendSeq))then{

	waitUntil{

		_enemy = _targetUnit findNearestEnemy _targetUnit;

		_targetUnit doWatch _enemy;
		_targetUnit doTarget _enemy;
		{_X doWatch _enemy; _X doTarget _enemy} forEach _additionalGuns;

		sleep 5;

		!(_targetUnit call BD_fnc_seesEnemy) || (isNull _enemy)

	};
	_suspendSeq = false;
};

// Play recorded data
/***********************/
_startedTime = (time - _skipTime);
_currentTime = time - _startedTime;
_lastPlayedFrame = 0;

// Plays the pre-recorded data
_totalData = count _capturedData;
_selectedData = 0;
_currentData = [];
_currentDataNext = [];
_frameTime = 0;
_tmpTime = 0;
_tmpTimeNext = 0;


while { ((_selectedData <= _totalData) && !(_suspendSeq)) } do
{
	// Suspend conditions
	if(!(alive _targetUnit) || {alive _X} count (crew (vehicle _targetUnit)) <= 0)then{_suspendSeq = true};
	if(!(_ignoreEnemy) && (_targetUnit call BD_fnc_seesEnemy))then{_suspendSeq = true};


	_currentData = (_capturedData select _selectedData);
	if ((_selectedData + 1) <= _totalData) then
	{
		_currentDataNext = (_capturedData select (_selectedData + 1));
	};
	_currentTime = time - _startedTime;
	_tmpTime = _currentData select 0;
	_tmpTimeNext = _currentDataNext select 0;
	
	_tmpPos = (vehicle _targetUnit) modelToWorld (_currentData select 1);
	
	_tmpPosNext = (vehicle _targetUnit) modelToWorld (_currentDataNext select 1);
	
	while { ((_tmpTimeNext >= _currentTime) && !(_endSeq)) } do
	{
			_tmpTimeDiff = (_currentTime - _tmpTime) / (_tmpTimeNext - _tmpTime);
			
			_tmpPosX = _tmpTimeDiff * ((_tmpPosNext select 0) - (_tmpPos select 0)) + (_tmpPos select 0);
			_tmpPosY = _tmpTimeDiff * ((_tmpPosNext select 1) - (_tmpPos select 1)) + (_tmpPos select 1);
			_tmpPosZ = _tmpTimeDiff * ((_tmpPosNext select 2) - (_tmpPos select 2)) + (_tmpPos select 2);
			_tmpPosNew = [_tmpPosX, _tmpPosY, _tmpPosZ];

			_targetUnit doWatch _tmpPosNew;
			{_X doWatch _tmpPosNew} forEach _additionalGuns;

			
			// Wait for next frame
			_frameTime = time;
			waitUntil {_frameTime < time};
			
			if (_sleep > 0) then {sleep _sleep;};
			
			_currentTime = time - _startedTime;
	};
	if (_tmpTime == 0) then
	{
		_tmpPos = (vehicle _targetUnit) modelToWorld (_currentData select 1);
	
		_targetUnit doWatch _tmpPos;
		{_X doWatch _tmpPosNew} forEach _additionalGuns;
		
		if (_sleep > 0) then {sleep _sleep;};
	};
	
	_selectedData = _selectedData + 1;
	if (_tmpTimeNext >= _currentTime) then
	{
		_frameTime = time;
		waitUntil {_frameTime < time};
	};
	
};

_endSeq = !(_looped);

};