//--------------------------------------------------------------------------------------------------
//Init the GVCM
//"Group Vehicle Control Module"
//
// All Variables in your mission should be set prior to GVCM, or otherwise directly stated
//       by xx-Cougar-xx  2009 AC - Cilithocal systems, P-Lab - Private, Non Commerical, non military use (LIC) only!
//--------------------------------------------------------------------------------------------------

//If true, your RPT log will show cycle report totals, false and it will show each conditional state and totals (debugging)
reportOnly = true;

//----------Markers------------- W.I.P
//Usage:
//Uses standard A2 markers for all except infantry- Colors are: West is Blue, East is red, Resistance is Orange, neutral and/or Civ's are White
//  setMrkFl = #;
//           = -1; ~Markers off
//           = 0;  ~Players only
//           = 1;  ~Vehicles only
//           = 2;  ~Vehicle and Players
setMrkFl = -1;

//set marker for infantry
infMrk = "mil_dot";

//set marker for wrecks
wrkMrk = "mil_triangle";

//You should not use mrkCa to reference your objects/markers, GVCM use only
mrkCa = [];

//You should not use mrkQu to reference your objects/markers, GVCM use only
mrkQu = [];

//internal use, GVCM use only
mpmAct = false;
//------------------------------

if (!isServer) exitWith{execVM "GVCM\c_gvcm.sqf";};

//Provided to stop GVCM control of group/Vehicles/units, do not change here.
//you should set (control Release) ctrlRelease to False run your script on group/Vehicle/Unit for creation or Deletion
//... then set ctrlRelease back to true, while the GVCM - is in a ctrlRelease = false state, it will cease to cycle and will cache only
//... It also uses ctrlRelease (ctrlRelease = false) during Deletion and Creation, you can perform your chks against this before Creation / Deletion.
ctrlRelease = true;

//About every XX seconds it will try to process something
//you can adjust this to a greater value, but the lowest is 15s (should be multples of 15)
cycleTime = 30;

//This is for Vehicles which can no longer move, after 'x' amount of time they will be handled  (should be multples of 60)
punishTime = 600;

//Expendable Empty Vehicles
//Empty expVehType vehicles after 'x' amount of time they will be handled, the value in sec is a Time Of Death since creation, realtive to the cycle.
//To disable this feature at ANY time make expTOD = -1;
//NOTES: ~If you disable after it was enabled, it will lose any stored info, and will take at least one cycle to reload.
//       ~If you do disable after it was enabled, it may take a cycle to be flagged. Before cycle is complete it may act as enabled.
//       ~If you remove a type at ANY time, that type will not be considered expendable from that point forward, realtive to cycle.
//       ~There is an inherent delay realtive to cycle times, where as it could think it is enabled/disabled and is not.
//2Hrs
expTOD = 7200;
// Ex: expVehType = ["StaticWeapon","Car"];
// Ex: expVehType = ["StaticWeapon","SkodaBase","VWGolf","Motorcycle"];
expVehType = ["StaticAAWeapon","StaticATWeapon","StaticCannon","StaticGrenadeLauncher","StaticMGWeapon","StaticMortar","Pickup_PK_base","Offroad_DSHKM_base","SkodaBase","VWGolf","Motorcycle","Bus"];

//If true GVCM will destroy vehicles with an effect, if false it will just delete with no effect
//CAUTION!!!!! desW_Effect = true can add a load (1-2 FPS as vehicle(s) is/are destroyed)to the server depending on server specs. 
desW_Effect = true;

//List the vehicles, for what ever reason you need to remain as wrecks in your mission, and/or that are handled by your mission 
//- http://community.bistudio.com/wiki/ArmA_2:_CfgVehicles
//EX: exWrecks = (someArray + anotherArray + ["A10", "AV8B2"]);
//EX: exWrecks = ["A10", "AV8B2"];
exWrecks = (["LAV25_HQ"]);

//Group Cache, by using the included functions (optional),grpCache is loaded to assit in deletion and markers with ctrlRelease handled for GVCM
//You should not use grpCache to reference your objects, GVCM will unload it.
grpCache = [];

//GVCM use only
gvcm_JIP_OPC = false;
gvcm_JIP_OPD = false;

//If you are not using any functions suppiled or intend on using the optional cache, comment next 3 script lines
// ***********Caution************
//The probablity for missing a group-vehicle-unit- for deletion and markers increases.
//If you do not use the functions, then insure you use crtlRelease with creation
call compile preprocessFileLineNumbers "GVCM\scripts\functions\xfnc_createGroup.sqf";
call compile preprocessFileLineNumbers "GVCM\scripts\functions\xfnc_createVehicleGroup.sqf";
call compile preprocessFileLineNumbers "GVCM\scripts\functions\xfnc_helpers.sqf";

execFSM "GVCM\fsms\GVCM.fsm";

if (true) exitWith {};
