//--------------------------------------
//File: xfnc_createVehicleGroup.sqf
//Version: 1.0
//
//Function that create vehicle group for GVCM | Missions
// --xfnc_createVehicle--
//      ~Based on BIS_fnc_spawnVehicle (overloaded)
//      ~Loads Variables for GVCM
//
//by xx-Cougar-xx  AC - Cilithocal systems, P-Lab
//Private, Non Commerical, non military use (LIC) only!
//--------------------------------------

xfnc_createVehicleGroup = {
private["_pos","_azi","_typeVeh","_side","_tmpArray","_tmpGrp","_vehCache","_crewCache"];
if ((count _this) < 4) exitWith {diag_log "ERROR: call to function-fs_createVehicleGroup, missing Parms"};

//pos, x and y
_pos = _this select 0;

_azi = _this select 1;
_typeVeh = _this select 2;
_side = _this select 3;

if ((typeName _side) != (typeName sideEnemy)) exitWith { diag_log "ERROR: call to function-fs_createVehicleGroup, Parm 3 is not a side"};

_tmpArray = [];
_tmpGrp = grpNull;
_vehCache = [];
_crewCache = [];

//take control from GVCM
ctrlRelease = false;
for "_i" from 0 to ((count _typeVeh) - 1) do
{
     //make first veh to develop group
     if(_i == 0) then {
          _tmpArray = [_pos, _azi, _typeVeh select _i, _side] call BIS_fnc_spawnVehicle;
          //Retrive
          _vehCache set[_i, _tmpArray select 0];
          _crewCache set[_i, _tmpArray select 1];
          _tmpGrp = _tmpArray select 2;
     }else {
          //For rest use grp parm
          _tmpArray = [_pos, _azi, _typeVeh select _i, _tmpGrp] call BIS_fnc_spawnVehicle;
          _vehCache set[_i, _tmpArray select 0];
          _crewCache set[_i, _tmpArray select 1];
     };
};
grpCache set[count grpCache, _tmpGrp];

//Rtn ctrl to GVCM
ctrlRelease = true;

//Return the Cache and grp
[_vehCache, _crewCache, _tmpGrp]

};