// ********************************************
// HunterKiller_Patrol.sqf
// Script File for ArmA2 with CBA
// Made by: Wiggum
// Version: 1.0
// ********************************************
// Enemy groups will patrol a specific area and inform each other inside a specific distance about spotted enemys
// If enemys are spotted the groups will start to hunt them
// A patroling group will reveal all spotted enemys closer then areasize (based on their current position) to all other units of the same side closer then  areasize * multi (based on their current position)
// A patroling group will only hunt enemys closer then areasize * multi (based on their current position)
// If you want a patrol to stay close to a specific position, dont give them a high multi !
// The groups will return to their patrolpos after the enemy is dead and start again to patrol there
// ********************************************
// Place a Function Modul on the map !
// Call from a trigger with condition "true" for each patrol group with:
// nul=[grphunter, patrolpos, areasize, multi, targetside, typeofhunter, typeoftarget, flarecount] execVM "HunterKiller_Patrol.sqf";
// ********************************************
// grphunter is the name of the patroling group
// patrolpos is the centre of the patrol, just place a empty H and give it a name
// areasize is the size of the area around the patrolpos in which the group will patrol
// multi is the multiplicator (of areasize) for the distance around the groupleader in which informations will be shared and received among the patrols. This also is the max. engagement range of the group !
// targetside is the side (west, east, resistance) of the possible targets of the patroling group
// typeofhunter is the type (take a look at CfgVehicles) of the patroling units (SoldierEB for all east units for example, can be different for some addons)
// typeoftarget is the type (take a look at CfgVehicles) of the possible targets (SoldierWB for all west units for example, can be different for some addons)
// flarecount is the number of flares the patroling group has, they will use them if a enemy is close enough (100m). Just give them 0 if you dont want that they use them. Flares will be spawned, no need for special weapons !
// ********************************************

if (!isServer) exitwith {};

private ["_grptargets","_grphunter","_areasize","_grpToHunt","_temp","_behaviour","_mode","_speed","_formation","_patrol","_targetside","_patrolpos","_ReadyToHunt","_HuntingDone","_multi","_typeofhunter","_typeoftarget","_hunterType","_targetType","_flare","_flarecount","_delay","_ammo","_dist","_dir","_height"];

_grphunter = _this select 0;
_patrolpos = _this select 1;
_areasize = _this select 2;
_multi = _this select 3;
_targetside = _this select 4;
_typeofhunter = _this select 5;
_typeoftarget = _this select 6;
_flarecount = _this select 7;

// Detection stuff and Variables
_grptargets =[];
_grpToHunt = nil;
_flare = nil;
_ReadyToHunt = 0;
_HuntingDone = 0;

// Behaviour of the group while hunting
_formation = ["WEDGE", "ECH LEFT", "ECH RIGHT", "VEE", "DIAMOND"] call BIS_fnc_selectRandom;
_speed = ["NORMAL", "FULL"] call BIS_fnc_selectRandom;
_behaviour = ["AWARE", "COMBAT"] call BIS_fnc_selectRandom;
_mode = ["YELLOW", "RED"] call BIS_fnc_selectRandom;

// Flare ammo, delay and offset from shooter
_ammo = ["F_40mm_White", "F_40mm_Red"] call BIS_fnc_selectRandom;
_delay = 5 + random 3;
_dist = 15 + random 15;
_dir = random 360;
_height = 200 + random 25;

// Begin the patrol
_patrol = [_grphunter, _patrolpos, _areasize, 7, "MOVE", "SAFE", "YELLOW", "LIMITED", "STAG COLUMN", "", [2,5,10]] call CBA_fnc_taskPatrol;
//hint "Patroling";

// Start of loop
while {({alive _x} count units _grphunter > 0)} do {
    
// Update position
_hunterType = nearestobjects [leader _grphunter,[_typeofhunter],(_areasize * _multi)];
_targetType = nearestobjects [leader _grphunter,[_typeoftarget],(_areasize)];

//Share current informations with other groups
{ 
_temp = _x;
{_temp reveal _x}  foreach _targetType;
} foreach _hunterType;
sleep 1;
    
// Add all west units inside _areasize to array _grptargets
{if ((count units _x>0 and side _x==_targetside) && ((leader _grphunter) knowsAbout (leader _x) >= 1.3) && ((leader _x) distance (leader _grphunter) <= (_areasize * _multi)) && (_ReadyToHunt == 0))  then {_grptargets=_grptargets+[_x]}} forEach allGroups;
sleep 1; 

// Choose the closest and set that group as possible _grpToHunt
if ((count _grptargets > 0) && (_ReadyToHunt == 0)) then { 
_grpToHunt = [_grptargets, leader _grphunter] call BIS_fnc_nearestPosition;
sleep 1;
};

// First check if there is any target
if !(isNil "_grpToHunt") then {
// If _grphunter knows about _grpToHunt and is in range then stop patrol and get ready to hunt them
if (((leader _grphunter) knowsAbout (leader _grpToHunt) >= 1.3) && ((leader _grphunter) distance (leader _grpToHunt) <= (_areasize * _multi)) && (_ReadyToHunt == 0) && ({alive _x} count units _grpToHunt > 0)) then {
terminate _patrol;
sleep 1;
while {(count (waypoints _grphunter)) > 0} do {
{
deleteWaypoint [_grphunter, 0];
[_grphunter, 0] setWPPos getpos leader _grphunter; 
} foreach  units _grphunter;
};
sleep 1;
{_x setBehaviour _behaviour; _x setCombatMode _mode; _x setSpeedMode _speed; _x setFormation _formation} foreach units _grphunter;
_ReadyToHunt = 1;
//hint "Ready for hunting";
sleep 1;
};
};

//Share current informations with other groups
{ 
_temp = _x;
{_temp reveal _x}  foreach _targetType;
} foreach _hunterType;
sleep 1;

// Hunting !
if (({alive _x} count units _grpToHunt > 0) && (_ReadyToHunt == 1)) then {
_grphunter move getPos (leader _grpToHunt);
//hint "Hunting Those Basterds !";
_HuntingDone = 1;
sleep 20;
};

// If _grphunter has flares and is close to _grpToHunt then shoot flare
if ((_flarecount > 0) && ((leader _grphunter) distance (leader _grpToHunt) <= 100) && ({alive _x} count units _grphunter > 0) && (_ReadyToHunt == 1)) then {   
//hint "Shooting flare";
sleep _delay;
if ({alive _x} count units _grphunter > 0) then {
_flare = _ammo createVehicle [(getPosASL (leader _grphunter) select 0) + (sin _dir) * _dist, (getPosASL (leader _grphunter) select 1) + (cos _dir) * _dist, _height];
// Playing a flaregun sound, change to a own custom sound if you like
// (leader _grphunter) say ["flaregun",5];
_flarecount = _flarecount - 1;
_delay = _delay + random 5;
};
};

// Start to patrol again
if (({alive _x} count units _grpToHunt == 0) && (_HuntingDone == 1))  then {
_HuntingDone = 0;
_ReadyToHunt = 0;
sleep 10;
_patrol = [_grphunter, _patrolpos, _areasize, 7, "MOVE", "SAFE", "RED", "LIMITED", "STAG COLUMN", "", [2,5,10]] call CBA_fnc_taskPatrol;
//hint "Patroling again";
sleep 10;
};

// End of Loop
};  