// Debugging aids
private ["_debugThis", "_artyGun", "_artyVector", "_gunLoc", "_targetPos"];
_debugThis = debugMsgOn && false;

///////////////////////////////////////////////////////////////////////////////

_artyGun = _this select 0;		// Type artillery unit
_artyVector = _this select 1;		// Type 3D vector

///////////////////////////////////////////////////////////////////////////////

_gunLoc = getpos _artyGun;

_tgtDistance = 50000;

// Set the target, combining the relative direction with the minion's location
_targetPos = [
	(_gunLoc select 0) + _tgtDistance * (_artyVector select 0),
	(_gunLoc select 1) + _tgtDistance * (_artyVector select 1),
	(_gunLoc select 2) + _tgtDistance * (_artyVector select 2)
];

if (_debugThis) then
{
	diag_log text format[
		"	Math check X: %1 + _tgtDistance * %2 = %3",
		(_gunLoc select 0),
		_artyVector select 0,
		_targetPos select 0
	];
	diag_log text format[
		"	Math check Y: %1 + _tgtDistance * %2 = %3",
		(_gunLoc select 1),
		_artyVector select 1,
		_targetPos select 1
	];
	diag_log text format[
		"	Math check Z: %1 + _tgtDistance * %2 = %3",
		(_gunLoc select 2),
		_artyVector select 2,
		_targetPos select 2
	];
};

_targetPos