// Debugging aids
private "_debugThis";
_debugThis = debugMsgOn && true;

///////////////////////////////////////////////////////////////////////////////

_artyMinion = _this select 0;		// Type artillery unit
_artyVector = _this select 1;		// Type 3D vector
_artyCanonGunType = _this select 2;	// Type string
_debugPlaceAmmoBox = _this select 3;

///////////////////////////////////////////////////////////////////////////////

if (_debugThis) then
{
	diag_log text "	== BEGIN artyExecuteAim ================";
	diag_log text format ["	%1 is attempting to aim.", name _artyMinion];
};

if ([_artyMinion, _artyCanonGunType] call fnArtyValidateMinion) then
{

	// Prevent minion from looking away from target
	_artyMinion disableAI "TARGET";
	_artyMinion disableAI "AUTOTARGET";

	// Set the target, combining the relative direction with the minion's location
	_targetPos = [vehicle _artyMinion, _artyVector] call fnArtyCalcAim;
	(vehicle _artyMinion) doWatch _targetPos;

	[getpos vehicle _artyMinion, name _artyMinion] call fnDebugOutputPosition;

	if (_debugThis) then
	{
		diag_log text format[
			"	Target location: [%1	%2	%3]",
			_targetPos select 0,
			_targetPos select 1,
			_targetPos select 2
		];

		_gunDir = (vehicle _artyMinion) weaponDirection ([_artyCanonGunType] call fnArtyGetMagazineType select 0);
		diag_log text format["	Aiming %1 at vector [%2	%3	%4]",
			_artyCanonGunType,
			_gunDir select 0,
			_gunDir select 1,
			_gunDir select 2];
	};

	// sleep (1.5 + random 1);

	// Report success
	_artyMinion groupChat "Firing solution locked in.";
}
else
{
	_artyMinion groupChat "Cannot execute order!";
	diag_log text format ["	%1 could not aim.", name _artyMinion];

	_minionUnit enableAI "TARGET";
	_minionUnit enableAI "AUTOTARGET";
};

if (_debugThis) then
{
	diag_log text "	== END artyExecuteAim ==================";
	diag_log text "";
};
