// Debugging aids
private "_debugThis";
_debugThis = debugMsgOn && true;

///////////////////////////////////////////////////////////////////////////////

_artyMinion = _this select 0;			// Type artillery units
_artyCanonGunType = _this select 1;		// Type string
_artyAmmoType = _this select 2;			// Type string
_maxRandomFiringDelay = _this select 3;		// Type float

///////////////////////////////////////////////////////////////////////////////

if (_debugThis) then
{
	diag_log text "	== BEGIN artyExecuteFire ================";
	diag_log text format ["	%1 is attempting to fire.", name _artyMinion];
};

if ([_artyMinion, _artyCanonGunType] call fnArtyValidateMinion) then
{
	_validatedDelay = random ((_maxRandomFiringDelay min 10) max 0.25);
	sleep _validatedDelay;

	if (_debugThis) then
	{
		diag_log text format[
			"	%4 firing %1 with gun %2 after %3 seconds",
			_artyAmmoType,
			_artyCanonGunType,
			_validatedDelay,
			name _artyMinion
		];
	};
	
	(vehicle _artyMinion) fire [[_artyCanonGunType] call fnArtyGetMagazineType select 0, "", _artyAmmoType];
	_artyMinion groupChat "Firing!";
}
else
{
	_artyMinion groupChat "Cannot execute order.";
	diag_log text format ["	%1 could not fire.", name _artyMinion];


	_artyMinion enableAI "TARGET";
	_artyMinion enableAI "AUTOTARGET";
};

if (_debugThis) then
{
	diag_log text "	== END artyExecuteFire ==================";
	diag_log text "";
};