// Debugging aids
private "_debugThis";
_debugThis = true && debugMsgOn;

///////////////////////////////////////////////////////////////////////////////

_artyGunType = _this select 0;			// Type String.  Get from (typeof vehicle _x)

///////////////////////////////////////////////////////////////////////////////

// TODO Support non-HE magazine types:
//	http://community.bistudio.com/wiki/Artillery_Module#ARTY_Vehicles_and_Magazines

private ["_baseGunType", "_magType"];

if (_debugThis) then
{
	diag_log text "			== BEGIN artyGetMagazineType ==================";
};

switch (_artyGunType) do
{
	case "M119": {
		_baseGunType = "M119";	// untested
		_magType = "ARTY_30Rnd_105mmHE_M119";
	};

	case "D30": {
		_baseGunType = "D30";	// untested
		_magType = "ARTY_30Rnd_122mmHE_D30";
	};

	case "M252": {
		_baseGunType = "M252";
		_magType = "ARTY_8Rnd_81mmHE_M252";
	};

	case "2b14_82mm": {
		_baseGunType = "2b14";
		_magType = "ARTY_8Rnd_82mmHE_2B14";
	};

	case "2b14_82mm_CDF": {
		_baseGunType = "2b14";
		_magType = "ARTY_8Rnd_82mmHE_2B14";
	};

	case "2b14_82mm_INS": {
		_baseGunType = "2b14";
		_magType = "ARTY_8Rnd_82mmHE_2B14";
	};

	case "2b14_82mm_GUE": {
		_baseGunType = "2b14";
		_magType = "ARTY_8Rnd_82mmHE_2B14";
	};

	case "MLRS": {
		_baseGunType = "MLRS";	// untested
		_magType = "ARTY_12Rnd_227mmHE_M270";
	};

	case "GRAD_CDF": {
		_baseGunType = "GRAD";	// untested
		_magType = "ARTY_40Rnd_120mmHE_BM21";
	};

	case "GRAD_INS": {
		_baseGunType = "GRAD";	// untested
		_magType = "ARTY_40Rnd_120mmHE_BM21";
	};

	case "GRAD_RU": {
		_baseGunType = "GRAD";	// untested
		_magType = "ARTY_40Rnd_120mmHE_BM21";
	};

	default {
		_baseGunType = "";
		_magType = "";
	};
};

if (_debugThis) then
{
	diag_log text format [
		"			Gun: %1, Base: %3, Mag: %2",
		_artyGunType,
		_magType,
		_baseGunType
	];
	diag_log text "			== END artyGetMagazineType ==================";
	diag_log text "";
};

[_baseGunType, _magType]