// Debugging aids
private "_debugThis";
_debugThis = debugMsgOn && false;

///////////////////////////////////////////////////////////////////////////////

_artyOfficers = _this select 0;			// Type array of units
_artyModule = _this select 1;			// Type artillery-module

///////////////////////////////////////////////////////////////////////////////

if (_debugThis) then
{
	diag_log text "== BEGIN artyInit ==================";
	diag_log text "";
};

if (isNil "artyValidCommanders") then
{
	artyValidCommanders = [];
};

// Keep a list of who is a valid artillery officer
artyValidCommanders = artyValidCommanders + _artyOfficers;

if (_debugThis) then
{
	_commanderList = "";
	{_commanderList = format ["%1, %2", _commanderList, name _x]} foreach artyValidCommanders;

	diag_log text format ["Valid commanders: %1", _commanderList];
};

// Synchronize officers with an arty module
if (not isNull _artyModule) then
{
	_artyModule synchronizeObjectsAdd _artyOfficers;
};

// Hide radio trigger commands from everyone but officers
[] execVM "artyOfficer\artySetOrderNames.sqf";

fnArtyGetMagazineType = compile preprocessFileLineNumbers "artyOfficer\artyGetMagazineType.sqf";
fnArtyValidateOfficer = compile preprocessFileLineNumbers "artyOfficer\artyValidateOfficer.sqf";
fnArtyValidateMinion = compile preprocessFileLineNumbers "artyOfficer\artyValidateMinion.sqf";
fnArtyCalcAim = compile preprocessFile "artyOfficer\artyCalculateAimTargetPosition.sqf";

if (_debugThis) then
{
	diag_log text "== END artyInit ==================";
	diag_log text "";
};
