// Debugging aids
private "_debugThis";
_debugThis = debugMsgOn && true;

///////////////////////////////////////////////////////////////////////////////

_artyOfficer = _this select 0;		// Type artillery group commander

///////////////////////////////////////////////////////////////////////////////

if (_debugThis) then
{
	diag_log text "== BEGIN artyOrderAim ================";
	diag_log text format["%1 is attempting to aim artillery!", name _artyOfficer];
	diag_log text "";
};

if ([_artyOfficer] call fnArtyValidateOfficer) then
{
	_artyMinions = units group _artyOfficer;
	_artyCanonGun = vehicle _artyOfficer;
	_artyCanonGunType = typeof _artyCanonGun;

	// Determine where the canonical piece is aiming
	_canonDir = _artyCanonGun weaponDirection ([_artyCanonGunType] call fnArtyGetMagazineType select 0);

	if (_debugThis) then
	{
		diag_log text "";
		diag_log text format[
			"Target vector: [%1	%2	%3], using %4",
			_canonDir select 0,
			_canonDir select 1,
			_canonDir select 2,
			_artyCanonGunType];

		[getPos _artyCanonGun, name _artyOfficer] call fnDebugOutputPosition;

		_targetPos = [_artyCanonGun, _canonDir] call compile preprocessFile "artyOfficer\artyCalculateAimTargetPosition.sqf";

		diag_log text format[
			"Target location: [%1	%2	%3]",
			_targetPos select 0,
			_targetPos select 1,
			_targetPos select 2
		];
	};

	{
		if (player != _x) then
		{
			[_x, _canonDir, _artyCanonGunType, _x == player] execVM "artyOfficer\artyExecuteAim.sqf";
		};
	}
	foreach _artyMinions;
}
else
{
	hint "Invalid order!";
};

if (_debugThis) then
{
	diag_log text "== END artyOrderAim ==================";
	diag_log text "";
};
