// Debugging aids
private "_debugThis";
_debugThis = debugMsgOn && true;

///////////////////////////////////////////////////////////////////////////////

_artyOfficer = _this select 0;		// Type artillery officer unit

///////////////////////////////////////////////////////////////////////////////

if (_debugThis) then
{
	diag_log text "== BEGIN artyOrderFire =================";
	diag_log text format["%1 is firing an artillery volley!", name _artyOfficer];
};

if ([_artyOfficer] call fnArtyValidateOfficer) then
{
	// Figure out what kind of gun we want the group to fire, and what magazine they're firing from
	_artyMinions = units group _artyOfficer;
	_artyCanonGunType = typeof vehicle _artyOfficer;
	_gunInfo = [typeof vehicle _artyOfficer] call fnArtyGetMagazineType;
	_artyCanonGunBase = _gunInfo select 0;
	_artyMagazineType = _gunInfo select 1;

	if (_debugThis) then
	{
		diag_log text format[
			"Firing %1 with gun %2",
			_artyMagazineType,
			_artyCanonGunType
		];
	};

	{
		if (player != _x) then
		{
			[_x, _artyCanonGunType, _artyMagazineType, 2] execVM "artyOfficer\artyExecuteFire.sqf";
		};
	}
	foreach _artyMinions;
}
else
{
	hint "Invalid order!";
};

if (_debugThis) then
{
	diag_log text "== END artyOrderFire ===================";
	diag_log text "";
};