// Debugging aids
private "_debugThis";
_debugThis = debugMsgOn && false;

///////////////////////////////////////////////////////////////////////////////

_artyMinion = _this select 0;			// Type artillery units
_artyCanonGunType = _this select 1;		// Type string

///////////////////////////////////////////////////////////////////////////////

// Minion must...
// ...be in the same type of vehicle as the officer
// ...be the gunner of his vehicle
// ...be in an artillery vehicle

private "_isValid";
_isValid = (_artyCanonGunType == typeOf vehicle _artyMinion) &&
	(_artyMinion == gunner vehicle _artyMinion) &&
	(([_artyCanonGunType] call fnArtyGetMagazineType) select 0 != "");

if (_debugThis) then
{
	if (_isValid) then
	{
		diag_log text format[
			"		== artyValidateMinion: %1 is a valid minion ==",
			name _artyMinion
		];
	}
	else
	{
		diag_log text format[
			"		== artyValidateMinion: %1 is not a valid minion ==",
			name _artyMinion
		];
	};
};

_isValid