_unit		= _this select 0;
_vehicle	= _this select 1;
_pos		= _this select 2;
_targetDir	= 0;
_viewRange	= [];
_frontPos	= false;
_stance		= "";

_place		= call compile preprocessFileLineNumbers "scripts\attach\vehicles.sqf";

_unit attachTo [_vehicle, _place];
_unit disableAI "MOVE";
_unit setUnitPos _stance;
doStop _unit;

// Standard direction
_initDir	= if (_frontPos) then
				{((_viewRange select 0) + (_viewRange select 1) + 360) / 2}
				else
				{((_viewRange select 0) + (_viewRange select 1)) / 2};
				
// Key assignments
if (isPlayer _unit) then
{
	pressedKey = compile preprocessFileLineNumbers "scripts\attach\keys.sqf";
	(findDisplay 46) displaySetEventHandler ["KeyDown", "_this call pressedKey"];
	muzzle	= 0;
};

while {(canStand _unit) && (canMove _vehicle)} do
{
	_target	= assignedTarget _unit;
	_vehicleDir	= getDir _vehicle;

	if (isNull _target) then
	{
		_unit setDir _initDir;
	}
	else
	{
		_targetDir	= ((getpos _target select 0) - (getpos _unit select 0)) atan2 ((getpos _target select 1) - (getpos _unit select 1));
		if(_targetDir < 0) then {_targetDir = _targetDir + 360};
		if ((_targetDir - _vehicleDir) < 0) then {_vehicleDir = _vehicleDir - 360};
		_targetDir	= _targetDir - _vehicleDir;
		switch true do
		{
			case(((_targetDir >= (_viewRange select 0)) || (_targetDir <= (_viewRange select 1))) && _frontPos):
			{_unit setDir _targetDir};
			case((_targetDir >= (_viewRange select 0)) && (_targetDir <= (_viewRange select 1))):
			{_unit setDir _targetDir};
		};
	};
	
	_unit setPos (getPos _unit);
	sleep 0.02;
};

detach _unit;
_unit enableAI "MOVE";
_unit setUnitPos "AUTO";
_unit setVariable ["onPos", nil];

if (isPlayer _unit) then {(findDisplay 46) displayRemoveAllEventHandlers "KeyDown"};