/*
Vehicles data
*/

switch (typeOf _vehicle) do
{
	case "UralOpen_INS":
	{
		switch true do
		{

			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [0, 360];
				_frontPos	= true;
				_stance		= "UP";
				[0, 0.4, -0.6]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange = [135, 225];
				_stance		= "MIDDLE";
				[0, -2.6, -0.6]
			};
		};
	};

	case "Ural_INS":
	{
		switch true do
		{

			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [135, 225];
				_stance		= "MIDDLE";
				[0, -2.6, -0.6]
			};
		};
	};

	case "MTVR":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [135, 225];
				_stance		= "MIDDLE";
				[0, -2.8, -0.5]
			};
		};
	};

	case "MTVR_DES_EP1":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [135, 225];
				_stance		= "MIDDLE";
				[0, -2.8, -0.5]
			};
		};
	};

	case "HMMWV_M998A2_SOV_DES_EP1":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [45, 315];
				_stance		= "MIDDLE";
				[0, -1.5, -1.1]
			};
		};
	};

	case "V3S_Gue":
	{
		switch true do
		{

			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [0, 360];
				_frontPos	= true;
				_stance		= "UP";
				[0, 0.6, -0.7]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange = [135, 225];
				_stance		= "MIDDLE";
				[0, -2.4, -0.7]
			};
		};
	};

	case "Fishing_Boat":
	{
		switch true do
		{

			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [225, 135];
				_frontPos	= true;
				_stance		= "MIDDLE";
				[0, 5.5, -2.5]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange = [90, 315];
				_stance		= "MIDDLE";
				[0, -5, -3.5]
			};
			case ((_pos == 2) && (_vehicle getVariable ["pos2", "free"]) == "free"):
			{
				_vehicle setVariable ["pos2", "occupied", true];
				_unit setVariable ["onPos", 2, true];
				_viewRange = [0, 360];
				_stance		= "UP";
				[-1, -0.2, -1.3]
			};
			case ((_pos == 3) && (_vehicle getVariable ["pos3", "free"]) == "free"):
			{
				_vehicle setVariable ["pos3", "occupied", true];
				_unit setVariable ["onPos", 3, true];
				_viewRange = [0, 360];
				_stance		= "UP";
				[-0.4, -2.2, 2.3]
			};
		};
	};

	case "Smallboat_1":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [225, 135];
				_frontPos	= true;
				_stance		= "MIDDLE";
				[0, 1.1, -0.8]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange = [90, 270];
				_stance		= "MIDDLE";
				[0, -1.2, -1]
			};
		};
	};

	case "smallboat_2":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [225, 135];
				_frontPos	= true;
				_stance		= "MIDDLE";
				[0, 1.1, -0.8]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange = [90, 270];
				_stance		= "MIDDLE";
				[0, -1.2, -1]
			};
		};
	};

	case "V3S_TK_EP1":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange = [135, 225];
				_stance		= "MIDDLE";
				[0, -2.4, -0.7]
			};
		};
	};

	case "V3S_Open_TK_EP1":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [0, 360];
				_frontPos	= true;
				_stance		= "UP";
				[0, 0.6, -0.7]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange = [135, 225];
				_stance		= "MIDDLE";
				[0, -2.4, -0.7]
			}
		};
	};

	case "BTR40_MG_TK_INS_EP1":
	{
		switch true do
		{

			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [0, 360];
				_frontPos	= false;
				_stance		= "MIDDLE";
				[-0.3, -1.6, -1.1]
			};
		};
	};

	case "BTR40_TK_INS_EP1":
	{
		switch true do
		{

			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [0, 360];
				_frontPos	= true;
				_stance		= "MIDDLE";
				[-0.3, 0, -0.9]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange = [0, 360];
				_stance		= "MIDDLE";
				[-0.3, -1.6, -0.9]
			};
		};
	};

	case "BAF_Merlin_HC3_D":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [225, 315];
				_frontPos	= false;
				_stance		= "MIDDLE";
				[-0.7, 5.2, -1.8]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange = [45, 135];
				_stance		= "MIDDLE";
				[1.2, 3, -1.8]
			};
		};
	};

	case "BAF_Offroad_D":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [135, 225];
				_frontPos	= false;
				_stance		= "MIDDLE";
				[0, -1.6, -0.8]
			};
		};
	};
	
	case "afr_pinz":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [135, 225];
				_frontPos	= false;
				_stance		= "MIDDLE";
				[0, -1.5, -0.1]
			};
		};
	};

	case "afr_pinz_police":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [135, 225];
				_frontPos	= false;
				_stance		= "MIDDLE";
				[0, -1.5, -0.1]
			};
		};
	};

	case "ibr_as350":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [30, 150];
				_frontPos	= false;
				_stance		= "UP";
				[1, 2, -2.21]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange = [210, 330];
				_stance		= "UP";
				[-1, 2, -2.21]
			};
		};
	};

	case "ibr_as350_jungle":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [30, 150];
				_frontPos	= false;
				_stance		= "UP";
				[1, 2, -2.21]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange = [210, 330];
				_stance		= "UP";
				[-1, 2, -2.21]
			};
		};
	};

	case "ibr_as350_specops":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [30, 150];
				_frontPos	= false;
				_stance		= "UP";
				[1, 2, -2.21]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange = [210, 330];
				_stance		= "UP";
				[-1, 2, -2.21]
			};
		};
	};

	// Cow!
	case "Cow01":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [225, 45];
				_frontPos	= true;
				_stance		= "UP";
				[0, 0.7, 0.5]
			};
		};
	};

	case "Cow02":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [225, 45];
				_frontPos	= true;
				_stance		= "UP";
				[0, 0.7, 0.5]
			};
		};
	};

	case "Cow03":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [225, 45];
				_frontPos	= true;
				_stance		= "UP";
				[0, 0.7, 0.5]
			};
		};
	};

	case "Cow04":
	{
		switch true do
		{
			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [225, 45];
				_frontPos	= true;
				_stance		= "UP";
				[0, 0.7, 0.5]
			};
		};
	};

	case "sigisolda1":
	{
		switch true do
		{

			case ((_pos == 0) && (_vehicle getVariable ["pos0", "free"]) == "free"):
			{
				_vehicle setVariable ["pos0", "occupied", true];
				_unit setVariable ["onPos", 0, true];
				_viewRange	= [0, 360];
				_frontPos	= false;
				_stance		= "UP";
				[0, 92.5, -3.1]
			};
			case ((_pos == 1) && (_vehicle getVariable ["pos1", "free"]) == "free"):
			{
				_vehicle setVariable ["pos1", "occupied", true];
				_unit setVariable ["onPos", 1, true];
				_viewRange	= [0, 180];
				_stance		= "DOWN";
				[10, 77, -3.3]
			};
			case ((_pos == 2) && (_vehicle getVariable ["pos2", "free"]) == "free"):
			{
				_vehicle setVariable ["pos2", "occupied", true];
				_unit setVariable ["onPos", 2, true];
				_viewRange = [180, 360];
				_stance		= "DOWN";
				[-10, 77, -3.3]
			};
			case ((_pos == 3) && (_vehicle getVariable ["pos3", "free"]) == "free"):
			{
				_vehicle setVariable ["pos3", "occupied", true];
				_unit setVariable ["onPos", 3, true];
				_viewRange = [0, 180];
				_stance		= "MIDDLE";
				[12, 45.5, -5.7]
			};
			case ((_pos == 4) && (_vehicle getVariable ["pos4", "free"]) == "free"):
			{
				_vehicle setVariable ["pos4", "occupied", true];
				_unit setVariable ["onPos", 4, true];
				_viewRange	= [180, 360];
				_frontPos	= false;
				_stance		= "MIDDLE";
				[-12, 45.5, -5.7]
			};
			case ((_pos == 5) && (_vehicle getVariable ["pos5", "free"]) == "free"):
			{
				_vehicle setVariable ["pos5", "occupied", true];
				_unit setVariable ["onPos", 5, true];
				_viewRange	= [0, 180];
				_stance		= "MIDDLE";
				[12, 0, -5.7]
			};
			case ((_pos == 6) && (_vehicle getVariable ["pos6", "free"]) == "free"):
			{
				_vehicle setVariable ["pos6", "occupied", true];
				_unit setVariable ["onPos", 6, true];
				_viewRange = [180, 360];
				_stance		= "MIDDLE";
				[-12, 0, -5.7]
			};
			case ((_pos == 7) && (_vehicle getVariable ["pos7", "free"]) == "free"):
			{
				_vehicle setVariable ["pos7", "occupied", true];
				_unit setVariable ["onPos", 7, true];
				_viewRange = [0, 180];
				_stance		= "MIDDLE";
				[12, -60, -5.7]
			};
			case ((_pos == 8) && (_vehicle getVariable ["pos8", "free"]) == "free"):
			{
				_vehicle setVariable ["pos8", "occupied", true];
				_unit setVariable ["onPos", 8, true];
				_viewRange	= [180, 360];
				_frontPos	= false;
				_stance		= "MIDDLE";
				[-12, -60, -5.7]
			};
			case ((_pos == 9) && (_vehicle getVariable ["pos9", "free"]) == "free"):
			{
				_vehicle setVariable ["pos9", "occupied", true];
				_unit setVariable ["onPos", 9, true];
				_viewRange	= [45, 225];
				_frontPos	= false;
				_stance		= "DOWN";
				[6.8, -79.6, 2.25]
			};
			case ((_pos == 10) && (_vehicle getVariable ["pos10", "free"]) == "free"):
			{
				_vehicle setVariable ["pos8", "occupied", true];
				_unit setVariable ["onPos", 10, true];
				_viewRange	= [135, 315];
				_frontPos	= false;
				_stance		= "DOWN";
				[-6.8, -79.6, 2.25]
			};
			case ((_pos == 11) && (_vehicle getVariable ["pos11", "free"]) == "free"):
			{
				_vehicle setVariable ["pos11", "occupied", true];
				_unit setVariable ["onPos", 11, true];
				_viewRange	= [45, 315];
				_stance		= "DOWN";
				[0, -92.5, -3.1]
			};
			case ((_pos == 12) && (_vehicle getVariable ["pos12", "free"]) == "free"):
			{
				_vehicle setVariable ["pos12", "occupied", true];
				_unit setVariable ["onPos", 12, true];
				_viewRange = [45, 225];
				_frontPos	= true;
				_stance		= "MIDDLE";
				[-1.7, 9.7, 3.1]
			};
			case ((_pos == 13) && (_vehicle getVariable ["pos13", "free"]) == "free"):
			{
				_vehicle setVariable ["pos13", "occupied", true];
				_unit setVariable ["onPos", 13, true];
				_viewRange = [180, 315];
				_frontPos	= true;
				_stance		= "UP";
				[12.6, -65.8, 5.3]
			};
		};
	};

};
