//**************************************************************************************************************
//Script: carpetbomb.sqf
//Version: 0.1b
//Author: The Darkbird
//Date: 04/2011
//Usage: _null = ["startmarker", "endmarker", ripples, bombs, spreadx, spready, totaltime] execVM carpetbomb.sqf
//Example: _null = ["start", "end", 50,5,15,170, 4] execVM "carpetbomb.sqf";
//***************************************************************************************************************

//Parameters
_startmarker = _this select 0; //Marker to start bombing from
_endmarker = _this select 1; //Marker to end bombing
_ripple = _this select 2; //Number of bomb ripples
_bombs = _this select 3; //Number of bombs per ripple
_xspread = _this select 4; //Randomness in x-axis
_yspread = _this select 5; //Randomness in y-axis
_time = _this select 6; //Total time to complete the carpet bomb (indicative, due to overhead)

//Location init
_x1 = getMarkerPos _startmarker select 0; //Start x
_y1 = getMarkerPos _startmarker select 1; //Start y 
_x2 = getMarkerPos _endmarker select 0; //End x
_y2 = getMarkerPos _endmarker select 1; //End y
_z = getMarkerPos _startmarker select 2; //z, which is always the same

//Calculations
_deltax = (_x1 - _x2)/(_ripple-1); //Calculate delta x (= movement per ripple)
_deltay = (_y1 - _y2)/(_ripple-1); //Calculate delta y (= movement per ripple)
_delay = _time /_ripple; //Calculate delay between ripples

if (isServer) then //Random function is local, so only execute on server in MP
{
    for [{_i=0},{_i < _ripple},{_i = _i +1}] do //For every ripple do
    {
            for [{_j=0},{_j < _bombs},{_j = _j +1}] do //For every bomb do
            {
                _gbu = "Bo_Mk82" createVehicle [_x1 + (random -_xspread) + (random _xspread), _y1 + (random -_yspread)+ (random _yspread) , _z]; //Make bomb
                _gbu setDamage 1; //Detonate bomb
            };//end for every bomb
            _x1 = _x1 - _deltax; //Move x-position
            _y1 = _y1 - _deltay; //Move y-position
            sleep _delay; //Delay
    };//end for ever ripple
};// end if 