/*
	Simple airdrop with script-support
	
	Requirements: CBA
	
	params: 
		caller,			// calling unit (object)
		vehicle,		// class of airplane doing the drop (string)
		approachFrom,	// approach vector (0-359) (-1 for random approach) (numeric)
		flyHeight,		// aircraft altitude (numeric)
		dropAt,			// starting drop position (multiple packages will be dropped at intervals) (position)
		interval,		// interval in seconds between drops (numeric)
		scripts,		// [ "ingress-script", "approach-script", "egress-script"]						
		items-array		// [
							[ "parachuteclass", "droppeditemclass", "script-to-run-on-item-drop", "script-to-run-on-item-after-touch-down" ], 
							[ "parachuteclass", "droppeditemclass", "script-to-run-on-item-drop", "script-to-run-on-item-after-touch-down" ]
						   ]
							(array)

	parachuteclasses:
		ParachuteMediumWest
		ParachuteMediumEast
		ParachuteBigWest
		ParachuteBigEast

	ingress-script:
		gets called with two parameters: caller (object), drop-vehicle (object)
		
	approach-script:
		gets called with two parameters: caller (object), drop-vehicle (object)

	egress-script:
		gets called with two parameters: caller (object), drop-vehicle (object)
						
	script-to-run-on-item-drop:
		gets called with three parameters: caller (object), drop-vehicle (object), package (object)

	script-to-run-on-item-after-touch-down:
		gets called with two parameters: caller (object), package (object)

	example:
		_n = [player, "c130j", 270, 200, getMarkerPos "mk_drop", 3, ["tbr_airdrop\ingress.sqf","tbr_airdrop\approach.sqf","tbr_airdrop\egress.sqf"], [["ParachuteMediumWest","USBasicAmmunitionBox_EP1","tbr_airdrop\announce.sqf",""],["ParachuteBigWest","HMMWV_M1035_DES_EP1","tbr_airdrop\announce.sqf","tbr_airdrop\explode.sqf"]]] execVM "tbr_airdrop\tbr_airdrop.sqf";
		
		uses a c130 to drop a ammo-box and a hmmwv (which blows up on touchdown thanks to a called script), both drops announced by the c130 (via script)
*/

private ["_approachFrom", "_interval", "_calc_point", "_caller", "_vehicleClass", "_dropAt", "_packages", "_flyHeight", "_dir", "_spawn_distance", "_spawn_pos", "_exit_pos", "_side", "_grp", "_vehicle", "_pilot", "_wp_drop", "_wp_exit"];

if( TBR_support_in_progress ) exitWith{ hint "Support already in progress"; };

_calc_point = {
	private ["_position", "_direction", "_distance", "_point", "_pos_x", "_pos_y", "_pos_z", "_off_x", "_off_y"];

	_position			= _this select 0;
	_direction			= _this select 1;
	_distance			= _this select 2;
	
	// ------------------------------------------------------
	
	_point				= [0,0,0];
	
	_pos_x 				= _position select 0;
	_pos_y 				= _position select 1;
	_pos_z				= _position select 2;

	_off_x	= sin(_direction) * _distance;
	_off_y	= cos(_direction) * _distance;

	_point	= [_pos_x + _off_x, _pos_y + _off_y, _pos_z];
	_point;
};

_caller			= _this select 0;
_vehicleClass	= _this select 1;
_approachFrom 	= _this select 2;
_flyHeight		= _this select 3;
_dropAt 		= _this select 4;
_interval 		= _this select 5;
_scripts		= _this select 6;
_packages 		= _this select 7;

if( _approachFrom == -1 ) then {
	_approachFrom = round(random 360);
} else {
	// randomize the approach angle somewhat
	_approachFrom	= [_approachFrom + (5 - round(random 10))] call CBA_fnc_simplifyAngle;
};

// set dropinterval if zero (2-5 seconds)
if( _interval == 0 ) then { _interval = 2 + round(random 3); };

_dir = _approachFrom - 180;
_dir = [_dir] call CBA_fnc_simplifyAngle;

_spawn_distance = viewDistance + 100;
_spawn_pos = [_dropAt, _approachFrom, _spawn_distance] call _calc_point;
_exit_pos = [_dropAt, _dir + (45 - round(random 90)), _spawn_distance] call _calc_point;

_side = side _caller;

_grp = createGroup _side;

TBR_support_in_progress = true;
TBR_drop_here = false;

publicVariable "TBR_support_in_progress";

_vehicle = createVehicle [_vehicleClass, [_spawn_pos select 0, _spawn_pos select 1, (_spawn_pos select 2) + _flyHeight], [], 0, "FLY"];
_vehicle setDir _dir;
_vehicle setVelocity [sin(_dir)*55,cos(_dir)*55,0]; // roughly 200kph

_pilot = _grp createUnit ["USMC_Soldier_Pilot", [0,0,0], [], 0, "FORM"];
_pilot assignAsDriver _vehicle;
_pilot moveInDriver _vehicle;
_vehicle flyInHeight _flyHeight;

// calling ingress-script
if( (_scripts select 0) != "" ) then { [_caller, _vehicle] execVM (_scripts select 0); };

// setup waypoints
_wp_drop = _grp addWaypoint [_dropAt, 50];
_wp_drop setWaypointType "MOVE";
_wp_drop setWaypointSpeed "LIMITED";
_wp_drop setWaypointStatements ["true", "TBR_drop_here = true;"];

_wp_exit = _grp addWaypoint [_exit_pos, 200];
_wp_exit setWaypointType "MOVE";
_wp_exit setWaypointSpeed "FULL";
_wp_exit setWaypointStatements ["true", "TBR_support_in_progress = false;"];

// monitoring approach
if( (_scripts select 1) != "" ) then {
	[_caller, _vehicle, _dropAt, (_scripts select 1)] spawn {
		private ["_caller", "_dropper", "_droppt", "_script"];
		
		_caller = _this select 0;
		_dropper = _this select 1;
		_droppt = _this select 2;
		_script = _this select 3;
		
		waitUntil{ ((getPos _dropper) distance _droppt) < 700  };
		
		// running approach-script
		[_caller, _dropper] execVM _script;
	};
};

waitUntil{ TBR_drop_here or !(alive _vehicle) };

if( !(alive _vehicle) ) exitWith{ TBR_support_in_progress = false; publicVariable "TBR_support_in_progress"; };

{
	[_vehicle, _x select 0, _x select 1, _x select 2, _x select 3, _caller] spawn {
		private ["_chute", "_smoke", "_touchDownPos", "_vel", "_dropper", "_chuteType", "_package", "_scriptAfter", "_scriptBefore", "_chutePos", "_drop", "_caller"];

		_dropper = _this select 0;
		_chuteType = _this select 1;
		_package = _this select 2;
		_scriptBefore = _this select 3;
		_scriptAfter = _this select 4;
		_caller = _this select 5;
		
		_chutePos = [(getpos _dropper select 0), (getPos _dropper select 1)-10, (getPos _dropper select 2)-10];

		// create the dropped object
		_drop = _package createVehicle _chutePos;
		_touchDownPos = [];
		
		if( _scriptBefore != "" ) then { [_caller, _dropper, _drop] execVM _scriptBefore; };
		
		if( _chuteType != "" ) then {
			// using parachute
			_chute = _chuteType createVehicle _chutePos; 
			_chute setPos _chutePos;
			
			_drop setpos _chutePos;
			_drop attachto [_chute, [0, 0, 0]];
			
			// add green smoke while dropping
			_smoke = "SmokeShellgreen" createVehicle _chutePos;
			_smoke attachto [_drop, [0, 0, 0]];
			
			waitUntil {((getPos _drop) select 2) < 1};
			
			detach _drop;
			detach _smoke;
			deleteVehicle _smoke;
			
			_touchDownPos = getPos _drop;
		} else {
			// no paracute, so it's freefalling
			_vel = velocity _dropper;
				
			// create a smokegrenade and use that as the "anchor" since it's affected by gravity
			_smoke = "SmokeShellgreen" createVehicle _chutePos;
			_drop attachto [_smoke, [0, 0, 0]];
			
			// set velocity vector to that of the plane, so the object falls somewhat realistically...
			_smoke setVelocity _vel;
			
			waitUntil {((getPos _smoke) select 2) < 1};
			
			_touchDownPos = getPos _smoke;

			detach _drop;
			deleteVehicle _smoke;
		};

		_drop setpos [(_touchDownPos select 0), (_touchDownPos select 1), 0];
		
		// create a new smokesource
		"SmokeShellgreen" createVehicle [(_touchDownPos select 0), (_touchDownPos select 1), 0];			

		if( _scriptAfter != "" ) then { 
			[_caller, _drop] execVM _scriptAfter; 
		};
	};

	sleep _interval + (random 2);
} forEach _packages;

waitUntil{ !TBR_support_in_progress or !(alive _vehicle) };

if( !(alive _vehicle) ) exitWith{ TBR_support_in_progress = false; publicVariable "TBR_support_in_progress"; };

// running egress-script
if( (_scripts select 2) != "" ) then { [_caller, _vehicle] execVM (_scripts select 2); };

sleep 1;

// cleanup
deleteVehicle _pilot;
deleteVehicle _vehicle;
deleteGroup _grp;

TBR_support_in_progress = false;
publicVariable "TBR_support_in_progress";