// TomNedry, 13oct11
#include "dialog\definitions.sqf"
disableSerialization;

_requestor = _this;
//
_artySite = getMarkerPos "artysite";
//
_corMarkerPos = getMarkerPos "corMarker"; //Has to be set from missionmaker on map grid 000/000
_corY = 0;
if ( (_corMarkerPos select 1)  > 10 ) then {
	_corY = (_corMarkerPos select 1);
};

_goAhead = true;

//Time between fire request
if (isNil "TNARTY_LastFireRequest") then {
	TNARTY_LastFireRequest = time;
} else {
	_elapsedTime = time - TNARTY_LastFireRequest;
	if ( (time - TNARTY_LastFireRequest) < TNARTY_TimeBetweenFireRequests) then {
		_goAhead = false;
		[playerSide,"HQ"] sideChat format["Reloading... Try in about %1 seconds....", round (TNARTY_TimeBetweenFireRequests - _elapsedTime)];
	};
};

if (_goAhead) then {
	TNARTY_LastFireRequest = time;
	//
	_dlg = findDisplay TN_ARTY_DIALOG;
	_crspFull = 0;

	_crsp1 = parseNumber (lbText [TNARTY_CoordRightSelfPos1_IDC,lbCurSel TNARTY_CoordRightSelfPos1_IDC]);
	_crsp2 = parseNumber (lbText [TNARTY_CoordRightSelfPos2_IDC,lbCurSel TNARTY_CoordRightSelfPos2_IDC]);
	_crsp3 = parseNumber (lbText [TNARTY_CoordRightSelfPos3_IDC,lbCurSel TNARTY_CoordRightSelfPos3_IDC]);
	_crsp4 = parseNumber (lbText [TNARTY_CoordRightSelfPos4_IDC,lbCurSel TNARTY_CoordRightSelfPos4_IDC]);

	_cusp1 = parseNumber (lbText [TNARTY_CoordUpSelfPos1_IDC,lbCurSel TNARTY_CoordUpSelfPos1_IDC]);
	_cusp2 = parseNumber (lbText [TNARTY_CoordUpSelfPos2_IDC,lbCurSel TNARTY_CoordUpSelfPos2_IDC]);
	_cusp3 = parseNumber (lbText [TNARTY_CoordUpSelfPos3_IDC,lbCurSel TNARTY_CoordUpSelfPos3_IDC]);
	_cusp4 = parseNumber (lbText [TNARTY_CoordUpSelfPos4_IDC,lbCurSel TNARTY_CoordUpSelfPos4_IDC]);

	_crtp1 = parseNumber (lbText [TNARTY_CoordRightTargetPos1_IDC,lbCurSel TNARTY_CoordRightTargetPos1_IDC]);
	_crtp2 = parseNumber (lbText [TNARTY_CoordRightTargetPos2_IDC,lbCurSel TNARTY_CoordRightTargetPos2_IDC]);
	_crtp3 = parseNumber (lbText [TNARTY_CoordRightTargetPos3_IDC,lbCurSel TNARTY_CoordRightTargetPos3_IDC]);
	_crtp4 = parseNumber (lbText [TNARTY_CoordRightTargetPos4_IDC,lbCurSel TNARTY_CoordRightTargetPos4_IDC]);

	_cutp1 = parseNumber (lbText [TNARTY_CoordUpTargetPos1_IDC,lbCurSel TNARTY_CoordUpTargetPos1_IDC]);
	_cutp2 = parseNumber (lbText [TNARTY_CoordUpTargetPos2_IDC,lbCurSel TNARTY_CoordUpTargetPos2_IDC]);
	_cutp3 = parseNumber (lbText [TNARTY_CoordUpTargetPos3_IDC,lbCurSel TNARTY_CoordUpTargetPos3_IDC]);
	_cutp4 = parseNumber (lbText [TNARTY_CoordUpTargetPos4_IDC,lbCurSel TNARTY_CoordUpTargetPos4_IDC]);

	_th1 = parseNumber (lbText [TNARTY_HeigthTargetPos1_IDC,lbCurSel TNARTY_HeigthTargetPos1_IDC]);

	_tdir = round abs sliderPosition TNARTY_DirectionSlider_IDC;

	CloseDialog 0;

	_crspFull = (_crsp1 * 10000.0) + (_crsp2 * 1000.0) + (_crsp3 * 100.0) + (_crsp4 * 10.0);
	_cuspFull = (_cusp1 * 10000.0) + (_cusp2 * 1000.0) + (_cusp3 * 100.0) + (_cusp4 * 10.0);

	tn_arty_coordinates = [_crsp1,_crsp2,_crsp3,_crsp4,_cusp1,_cusp2,_cusp3,_cusp4,_crtp1,_crtp2,_crtp3,_crtp4,_cutp1,_cutp2,_cutp3,_cutp4,_th1/*,_th2,_th3,_th4,_tdir*/];

	//4th digit correction to stay with UTM procedures (x/y = lat/lon = right/up)
	_reportCutp4 = _cutp4;
	if (TNARTY_UTMCorr) then {
		if (_cutp4 > 0) then {
			_cutp4 = 10.0 - _cutp4;
		};
	};
	//
	_crtpFull = (_crtp1 * 10000.0) + (_crtp2 * 1000.0) + (_crtp3 * 100.0) + (_crtp4 * 10.0);
	_cutpFull = _corY - ( (_cutp1 * 10000.0) + (_cutp2 * 1000.0) + (_cutp3 * 100.0) + (_cutp4 * 10.0) ) ;
	if (_corY == 0 ) then
	{
		_cutpFull = ( (_cutp1 * 10000.0) + (_cutp2 * 1000.0) + (_cutp3 * 100.0) + (_cutp4 * 10.0) ) ;
	};
	// Spread
	_spreadDistance = (_artySite distance [_crtpFull,_cutpFull,0]) / 1000.0;
	_spread = (exp (_spreadDistance/2) ) * 2; 
	//
	_spread = _spread + _tdir; //Add requested spread

	// Time to target
	_v0 = 174; //81mm
	_timeToTarget = sqrt(( ( 9.81 * _spreadDistance * _spreadDistance * 1000000) / ( 2 * _v0 * _v0) ) * 2 / 9.81 );
	//
	//Arty local preferences
	_ammoType = TNARTY_ammoType;
	_target = [_crtpFull, _cutpFull, 0];
	_delay = 2.0; 
	_heightOfShells = 200; 
	_amountOfShells = _th1;

	if (_amountOfShells > TNARTY_ShellsLeftNumber) then {
		_amountOfShells = TNARTY_ShellsLeftNumber;
	};

	_requestor sideChat format["Fire request ... %1%2%3%4/%5%6%7%8 ... %10 rounds ... spread %9 ... OVER",_crtp1,_crtp2,_crtp3,_crtp4,_cutp1,_cutp2,_cutp3,_reportCutp4,round _tdir,round _th1];

	if (TNARTY_ShellsLeftNumber < 1) exitWith {
		[playerSide,"HQ"] sideChat "We are out of ammo. Request rejected.... OUT";
	};
	//Reduce amount ao shells
	TNARTY_ShellsLeftNumber = TNARTY_ShellsLeftNumber - _th1;
	sleep 2 + random 2;
	[playerSide,"HQ"] sideChat format["%3 shells ... Impact: %1 seconds ..., Spread: %2 m ...  OVER",round _timeToTarget, round _spread, _amountOfShells];
	sleep _timeToTarget;

	//Poor man artillery
	for "_x" from 1 to _amountOfShells do {
		_targetpos = [_target select 0, _target select 1, _heightOfShells];
		_Strike = createVehicle [_ammoType, _targetpos, [], _spread, "NONE"];
		_Strike  allowdamage false;
		_Strike  setvectorup [0,9,0.1];
		_Strike setvelocity [0,0,-200];
		sleep _delay;
	}; 

	sleep 2 + random 2;
	[playerSide,"HQ"] sideChat "Shot, Over";
	sleep (2 + random 2);
	_requestor sideChat "Shot, Out";

};
if(true) exitWith{};