/*
 * Decompiled with CFR 0.152.
 */
package emrptviewer;

import emrptviewer.BareBonesBrowserLaunch;
import emrptviewer.ConnectThread;
import emrptviewer.DisplayThread;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class View
extends JFrame {
    ImageIcon img = new ImageIcon(this.getClass().getResource("/emrptviewer/logo50.png"));
    static ArrayList<String> rawRPTList = new ArrayList();
    static ArrayList<String> woundsRPTList = new ArrayList();
    static ArrayList<String> missingRPTList = new ArrayList();
    String currentFile = "";
    String currentTimeZone = "";
    String currentOutput = "wounds";
    static Timer timer;
    static DefaultTableModel connectionsTableModel;
    private JButton aboutCloseButton;
    private JFrame aboutFrame;
    private JLabel aboutLogoLabel;
    private JMenuItem aboutMenuItem;
    private JButton addServerButton;
    private JTextField addressField;
    private JButton connectButton;
    private JFrame connectFrame;
    private JMenuItem connectMenuItem;
    private JTable connectionsTable;
    private JTextField displayNameField;
    private JLabel displayNameLabel;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JMenuBar mainMenu;
    private JButton newServerButton;
    private JFrame newServerFrame;
    private static JTextPane outputPane;
    private JMenuItem rawOutputMenuItem;
    private JMenuItem refreshMenuItem;
    private static JLabel statusLabel;
    private static JLabel statusLabelValue;
    private JPanel statusPanel;
    private static JLabel timeLabel;
    private JTextField timeZoneField;
    private JLabel timeZoneLabel;
    private JLabel timeZoneLabel1;
    private JMenu viewMenu;
    private JLabel websiteLabel;
    private JMenuItem websiteMenuItem;
    private JMenuItem woundsOutputMenuItem;

    public View() {
        this.setIconImage(this.img.getImage());
        this.initComponents();
        this.init();
    }

    private void initComponents() {
        this.aboutFrame = new JFrame();
        this.aboutLogoLabel = new JLabel();
        this.aboutCloseButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.websiteLabel = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.connectFrame = new JFrame();
        this.jScrollPane2 = new JScrollPane();
        this.connectionsTable = new JTable();
        this.connectButton = new JButton();
        this.newServerButton = new JButton();
        this.newServerFrame = new JFrame();
        this.jLabel8 = new JLabel();
        this.displayNameLabel = new JLabel();
        this.displayNameField = new JTextField();
        this.timeZoneLabel = new JLabel();
        this.timeZoneField = new JTextField();
        this.addressField = new JTextField();
        this.timeZoneLabel1 = new JLabel();
        this.addServerButton = new JButton();
        this.statusPanel = new JPanel();
        statusLabel = new JLabel();
        statusLabelValue = new JLabel();
        timeLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        outputPane = new JTextPane();
        this.mainMenu = new JMenuBar();
        this.fileMenu = new JMenu();
        this.connectMenuItem = new JMenuItem();
        this.refreshMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.rawOutputMenuItem = new JMenuItem();
        this.woundsOutputMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.websiteMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.aboutFrame.setIconImage(this.img.getImage());
        this.aboutFrame.setTitle("EM RPT Viewer: About");
        this.aboutFrame.setAlwaysOnTop(true);
        this.aboutFrame.setMinimumSize(new Dimension(450, 250));
        this.aboutFrame.setResizable(false);
        this.aboutLogoLabel.setIcon(new ImageIcon(this.getClass().getResource("/emrptviewer/logosmall.png")));
        this.aboutLogoLabel.setToolTipText("");
        this.aboutCloseButton.setText("Close");
        this.aboutCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                View.this.aboutCloseButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Verdana", 1, 18));
        this.jLabel1.setText("EM RPT Viewer");
        this.jLabel2.setText("Version:");
        this.jLabel3.setText("1.1");
        this.jLabel4.setText("Author:");
        this.websiteLabel.setText("Website:");
        this.jLabel6.setFont(new Font("Arial", 0, 11));
        this.jLabel6.setForeground(new Color(0, 51, 255));
        this.jLabel6.setText("<html><a>http://em-creations.co.uk</a></html>");
        this.jLabel6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                View.this.jLabel6MouseClicked(evt);
            }
        });
        this.jLabel7.setText("Edward McKnight");
        GroupLayout aboutFrameLayout = new GroupLayout(this.aboutFrame.getContentPane());
        this.aboutFrame.getContentPane().setLayout(aboutFrameLayout);
        aboutFrameLayout.setHorizontalGroup(aboutFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(aboutFrameLayout.createSequentialGroup().addContainerGap().addComponent(this.aboutLogoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(aboutFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(aboutFrameLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7)).addGroup(aboutFrameLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.aboutCloseButton).addGroup(aboutFrameLayout.createSequentialGroup().addGroup(aboutFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.websiteLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(aboutFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6, -2, -1, -2).addComponent(this.jLabel3))))).addContainerGap(15, Short.MAX_VALUE)));
        aboutFrameLayout.setVerticalGroup(aboutFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, aboutFrameLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(aboutFrameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(aboutFrameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.websiteLabel).addComponent(this.jLabel6, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(aboutFrameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.aboutCloseButton).addContainerGap()).addGroup(aboutFrameLayout.createSequentialGroup().addComponent(this.aboutLogoLabel).addGap(0, 0, Short.MAX_VALUE)));
        this.connectFrame.setIconImage(this.img.getImage());
        this.connectFrame.setTitle("EM RPT Viewer: Connect");
        this.connectFrame.setMinimumSize(new Dimension(463, 244));
        this.connectionsTable.setFont(new Font("Arial", 0, 11));
        this.connectionsTable.setModel(connectionsTableModel);
        this.connectionsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                View.this.connectionsTableMouseClicked(evt);
            }
        });
        this.connectionsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                View.this.connectionsTableKeyReleased(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.connectionsTable);
        this.connectButton.setText("Connect");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                View.this.connectButtonActionPerformed(evt);
            }
        });
        this.newServerButton.setText("New");
        this.newServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                View.this.newServerButtonActionPerformed(evt);
            }
        });
        GroupLayout connectFrameLayout = new GroupLayout(this.connectFrame.getContentPane());
        this.connectFrame.getContentPane().setLayout(connectFrameLayout);
        connectFrameLayout.setHorizontalGroup(connectFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectFrameLayout.createSequentialGroup().addContainerGap().addGroup(connectFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, connectFrameLayout.createSequentialGroup().addGap(0, 3, Short.MAX_VALUE).addComponent(this.jScrollPane2, -2, 438, -2)).addGroup(GroupLayout.Alignment.TRAILING, connectFrameLayout.createSequentialGroup().addComponent(this.newServerButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.connectButton))).addContainerGap()));
        connectFrameLayout.setVerticalGroup(connectFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectFrameLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 190, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(connectFrameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connectButton).addComponent(this.newServerButton)).addGap(6, 6, 6)));
        this.newServerFrame.setIconImage(this.img.getImage());
        this.newServerFrame.setTitle("EM RPT Viewer: New Server");
        this.newServerFrame.setMinimumSize(new Dimension(250, 225));
        this.jLabel8.setFont(new Font("Arial", 1, 16));
        this.jLabel8.setText("New Server");
        this.displayNameLabel.setText("Display Name:");
        this.timeZoneLabel.setText("Time Zone:");
        this.timeZoneLabel1.setText("Address:");
        this.addServerButton.setText("Add");
        this.addServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                View.this.addServerButtonActionPerformed(evt);
            }
        });
        GroupLayout newServerFrameLayout = new GroupLayout(this.newServerFrame.getContentPane());
        this.newServerFrame.getContentPane().setLayout(newServerFrameLayout);
        newServerFrameLayout.setHorizontalGroup(newServerFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(newServerFrameLayout.createSequentialGroup().addContainerGap().addGroup(newServerFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addGroup(newServerFrameLayout.createSequentialGroup().addGroup(newServerFrameLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.timeZoneLabel).addComponent(this.displayNameLabel).addComponent(this.timeZoneLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(newServerFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayNameField, -2, 99, -2).addComponent(this.timeZoneField, -2, 99, -2).addComponent(this.addressField, -2, 99, -2)))).addContainerGap(63, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, newServerFrameLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.addServerButton).addContainerGap()));
        newServerFrameLayout.setVerticalGroup(newServerFrameLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(newServerFrameLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel8).addGap(11, 11, 11).addGroup(newServerFrameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayNameLabel).addComponent(this.displayNameField, -2, -1, -2)).addGap(14, 14, 14).addGroup(newServerFrameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeZoneField, -2, -1, -2).addComponent(this.timeZoneLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(newServerFrameLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressField, -2, -1, -2).addComponent(this.timeZoneLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 65, Short.MAX_VALUE).addComponent(this.addServerButton).addContainerGap()));
        this.setDefaultCloseOperation(3);
        this.setTitle("EM RPT Viewer");
        this.setName("mainFrame");
        statusLabel.setText("placeHolder");
        statusLabelValue.setText("Waiting..");
        timeLabel.setText("placeHolder");
        timeLabel.setToolTipText("Server Time");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(statusLabelValue)).addComponent(timeLabel)).addContainerGap(441, Short.MAX_VALUE)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(timeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(statusLabel).addComponent(statusLabelValue)).addContainerGap()));
        outputPane.setEditable(false);
        outputPane.setFont(new Font("Arial", 1, 12));
        this.jScrollPane1.setViewportView(outputPane);
        this.fileMenu.setText("File");
        this.connectMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.connectMenuItem.setText("Connect..");
        this.connectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                View.this.connectMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.connectMenuItem);
        this.refreshMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.refreshMenuItem.setText("Refresh");
        this.refreshMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                View.this.refreshMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.refreshMenuItem);
        this.mainMenu.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.rawOutputMenuItem.setText("Raw Output");
        this.rawOutputMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                View.this.rawOutputMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.rawOutputMenuItem);
        this.woundsOutputMenuItem.setText("Wounds Output");
        this.woundsOutputMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                View.this.woundsOutputMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.woundsOutputMenuItem);
        this.mainMenu.add(this.viewMenu);
        this.helpMenu.setText("Help");
        this.websiteMenuItem.setText("Website");
        this.websiteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                View.this.websiteMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.websiteMenuItem);
        this.aboutMenuItem.setText("About..");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                View.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.mainMenu.add(this.helpMenu);
        this.setJMenuBar(this.mainMenu);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 537, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 202, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.statusPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void refreshMenuItemActionPerformed(ActionEvent evt) {
        if (this.currentFile.equals("") || this.currentTimeZone.equals("")) {
            this.displayError("File and / or time zone not set");
        } else {
            ConnectThread connectThread = new ConnectThread(this.currentFile, this.currentTimeZone, this.currentOutput);
            connectThread.run();
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        this.aboutFrame.setVisible(true);
        this.aboutFrame.setFocusableWindowState(true);
    }

    private void aboutCloseButtonActionPerformed(ActionEvent evt) {
        this.aboutFrame.setFocusableWindowState(false);
        this.aboutFrame.setVisible(false);
    }

    private void websiteMenuItemActionPerformed(ActionEvent evt) {
        BareBonesBrowserLaunch.openURL("http://www.em-creations.co.uk");
    }

    private void jLabel6MouseClicked(MouseEvent evt) {
        BareBonesBrowserLaunch.openURL("http://www.em-creations.co.uk");
    }

    private void connectMenuItemActionPerformed(ActionEvent evt) {
        this.connectFrame.setVisible(true);
        this.connectFrame.setFocusableWindowState(true);
    }

    private void connectButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.connectionsTable.getSelectedRow();
        if (selectedRow == -1) {
            this.displayError("No server selected");
        } else {
            this.currentFile = connectionsTableModel.getValueAt(selectedRow, 2).toString();
            this.currentTimeZone = connectionsTableModel.getValueAt(selectedRow, 1).toString();
            ConnectThread connectThread = new ConnectThread(this.currentFile, this.currentTimeZone, "wounds");
            connectThread.run();
        }
    }

    private void connectionsTableMouseClicked(MouseEvent evt) {
        int clicks = evt.getClickCount();
        if (clicks == 2) {
            int selectedRow = this.connectionsTable.rowAtPoint(evt.getPoint());
            this.currentFile = connectionsTableModel.getValueAt(selectedRow, 2).toString();
            this.currentTimeZone = connectionsTableModel.getValueAt(selectedRow, 1).toString();
            ConnectThread connectThread = new ConnectThread(this.currentFile, this.currentTimeZone, "wounds");
            connectThread.run();
        }
    }

    private void rawOutputMenuItemActionPerformed(ActionEvent evt) {
        this.currentOutput = "raw";
        DisplayThread displayThread = new DisplayThread("raw");
        displayThread.run();
    }

    private void woundsOutputMenuItemActionPerformed(ActionEvent evt) {
        this.currentOutput = "wounds";
        DisplayThread displayThread = new DisplayThread("wounds");
        displayThread.run();
    }

    private void newServerButtonActionPerformed(ActionEvent evt) {
        this.newServerFrame.setVisible(true);
        this.newServerFrame.setFocusableWindowState(true);
    }

    private void addServerButtonActionPerformed(ActionEvent evt) {
        String displayName = this.displayNameField.getText();
        String timeZone = this.timeZoneField.getText();
        String address = this.addressField.getText();
        if (displayName.isEmpty()) {
            this.displayError("No display name");
        } else if (timeZone.isEmpty()) {
            this.displayError("No time zone");
        } else if (address.isEmpty()) {
            this.displayError("No address");
        } else if (!address.startsWith("https://") && !address.startsWith("http://")) {
            this.displayError("Address must start with https:// or http://");
        } else {
            timeZone = timeZone.replace(" ", "_");
            String dir = System.getProperty("user.dir");
            try {
                FileWriter fstream = new FileWriter(dir + "/servers.csv");
                BufferedWriter out = new BufferedWriter(fstream);
                for (int i = 0; i < connectionsTableModel.getRowCount(); ++i) {
                    out.write(connectionsTableModel.getValueAt(i, 0) + "," + connectionsTableModel.getValueAt(i, 1) + "," + connectionsTableModel.getValueAt(i, 2) + "\n");
                }
                out.write(displayName + "," + timeZone + "," + address + "\n");
                out.close();
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
            this.populateConnectTable(true);
            this.displayNameField.setText("");
            this.timeZoneField.setText("");
            this.addressField.setText("");
            this.newServerFrame.setVisible(false);
            this.newServerFrame.setFocusableWindowState(false);
        }
    }

    private void connectionsTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyChar() == '\u007f') {
            int selectedRow = this.connectionsTable.getSelectedRow();
            if (selectedRow == -1) {
                this.displayError("No server selected");
            } else {
                String dir = System.getProperty("user.dir");
                try {
                    FileWriter fstream = new FileWriter(dir + "/servers.csv");
                    BufferedWriter out = new BufferedWriter(fstream);
                    String toWrite = "";
                    for (int i = 0; i < this.connectionsTable.getRowCount(); ++i) {
                        if (i == selectedRow) continue;
                        toWrite = toWrite + this.connectionsTable.getValueAt(i, 0) + "," + this.connectionsTable.getValueAt(i, 1) + "," + this.connectionsTable.getValueAt(i, 2) + "\n";
                    }
                    out.write(toWrite);
                    out.close();
                }
                catch (Exception e) {
                    System.err.println("Error: " + e.getMessage());
                }
                this.populateConnectTable(true);
            }
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new View().setVisible(true);
            }
        });
    }

    private void init() {
        statusLabel.setText("");
        statusLabelValue.setText("");
        timeLabel.setText("");
        this.populateConnectTable();
        final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss z");
        timeFormat.setTimeZone(TimeZone.getDefault());
        ActionListener timerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date date = new Date();
                String time = timeFormat.format(date);
                timeLabel.setText(time);
            }
        };
        timer = new Timer(1000, timerListener);
        timer.setInitialDelay(0);
        timer.start();
    }

    private static String getExecutionPath() {
        String absolutePath = View.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        absolutePath = absolutePath.substring(0, absolutePath.lastIndexOf("/"));
        absolutePath = absolutePath.replace("%20", " ");
        return absolutePath;
    }

    public static void readFile(String file, String timeZone) {
        timer.stop();
        final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss z");
        timeFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
        ActionListener timerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date date = new Date();
                String time = timeFormat.format(date);
                timeLabel.setText(time);
            }
        };
        timer = new Timer(1000, timerListener);
        timer.setInitialDelay(0);
        timer.start();
        statusLabel.setText("Loading file..");
        statusLabelValue.setText("");
        outputPane.setText("");
        rawRPTList.clear();
        woundsRPTList.clear();
        System.out.println("Starting to fetch data..\n");
        try {
            String inputLine;
            URL serverURL = new URL(file);
            URLConnection yc = serverURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                rawRPTList.add(inputLine);
                boolean woundsCond = inputLine.contains(" has been killed by ") || inputLine.contains(" has been wounded by ") || inputLine.contains(" has been team wounded by ");
                if (!woundsCond) continue;
                woundsRPTList.add(inputLine);
            }
            in.close();
            statusLabel.setText("File:");
            statusLabelValue.setText(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            statusLabel.setText("Error:");
            statusLabelValue.setText(e.getStackTrace().toString());
        }
        System.out.println("Finished fetching data.\n");
    }

    public static void displayOutput(String display) {
        ArrayList<String> toOutput;
        switch (display) {
            case "wounds": {
                toOutput = woundsRPTList;
                break;
            }
            case "raw": {
                toOutput = rawRPTList;
                break;
            }
            case "missing": {
                toOutput = missingRPTList;
                break;
            }
            default: {
                toOutput = rawRPTList;
            }
        }
        StyledDocument doc = outputPane.getStyledDocument();
        Style style1 = outputPane.addStyle("style1", null);
        StyleConstants.setForeground(style1, Color.darkGray);
        Style style2 = outputPane.addStyle("style2", null);
        StyleConstants.setForeground(style2, Color.gray);
        outputPane.setText("");
        try {
            int i = 0;
            for (String s : toOutput) {
                if (i % 2 == 0) {
                    doc.insertString(doc.getLength(), s + "\n", style1);
                } else {
                    doc.insertString(doc.getLength(), s + "\n", style2);
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    private void populateConnectTable() {
        this.populateConnectTable(false);
    }

    private void populateConnectTable(boolean reloading) {
        String dir = View.getExecutionPath();
        System.out.println("Directory: " + dir);
        if (!reloading) {
            connectionsTableModel.addColumn("Server");
            connectionsTableModel.addColumn("Time Zone");
            connectionsTableModel.addColumn("Address");
        } else {
            this.connectionsTable.updateUI();
            for (int i = connectionsTableModel.getRowCount() - 1; i >= 0; --i) {
                connectionsTableModel.removeRow(i);
            }
        }
        File servers = new File(dir + "/servers.csv");
        if (servers.exists()) {
            System.out.println("File exists");
            try {
                String strLine;
                FileInputStream fstream = new FileInputStream(dir + "/servers.csv");
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((strLine = br.readLine()) != null) {
                    String[] lineArr = strLine.split(",");
                    connectionsTableModel.addRow(new Object[]{lineArr[0], lineArr[1], lineArr[2]});
                }
                in.close();
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
    }

    private void displayError(String errorText) {
        statusLabel.setText("Error:");
        statusLabelValue.setText(errorText);
    }

    static {
        connectionsTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
    }
}

