#include "lib\common.h"

#define RUNNING 0
#define STOPPED 1

frameBuffers = [];
running = false;

maxExpectedFPS = 100;

frameMonitor =
{
	private ["_lastFrame","_offset","_state","_tickTimeZero"];
	_lastFrame = 0;
	_state = STOPPED;
	_tickTimeZero = diag_tickTime;
	while {true} do
	{
		waitUntil {diag_frameno != _lastFrame};
		_lastFrame = diag_frameno;
		switch (_state) do
		{
			case RUNNING:
			{
				//TODO - put some protection in here for overflowing the buffer
				framebuffer set [_offset,diag_tickTime - _tickTimeZero];
				_offset = _offset +1;
				if (not running) then
				{
					frameBuffer resize _offset;
					_state = STOPPED;
				};
			};
			case STOPPED:
			{
				if (running) then
				{
					_offset = 0;
					_state = RUNNING;
				};
			};
		};
	};
};
//ARGS are name and duration
prepare =
{
	_fb = [];
	_fb resize (ARG1* maxExpectedFPS);
	frameBuffers = frameBuffers + [[ARG0,_fb]];
	frameBuffer = _fb;
};
start =
{
	_this call prepare;
	running = true;
};
stopBM =
{
	running = false;
};
reset =
{
	frameBuffers = [];
};
numFrames =
{
	count EL((EL(frameBuffers,0)),1);
};
present =
{
	private ["_name","_fb"];
	{
		_name = EL(_x,0);
		diag_log ["START FPS TRACE ",diag_tickTime,_name];
		diag_log format ["LABEL %1",_name];
		_fb = EL(_x,1);
		{
			diag_log _x;
		} forEach _fb;
		diag_log ["END FPS TRACE"];
	} forEach frameBuffers;
};
fpsActions =
[
	["height","setNum",-1],
	["target","setString",""],
	["nolog","settrue",false],
	["speed","setNum",-1]
];

endLoadingScreen;

[] spawn
{
	sleep 1;
	//[] spawn {call frameMonitor;};

	//prepare waypoints
	_markers = [];
	{
		_m = _x;
		_s = [_m,false] call getRegionAndModifiers;
		//diag_log [_m,_s];
		_r = [_s,fpsActions] call handleActions;
		_markers = _markers + [_r];
	} forEach (["fps"] call findMarkers);;

	_fps0 = EL(_markers,0);

	_nolog = VAR(_fps0,nolog);

	_cam = "camera" camCreate position player;
	_cam cameraEffect ["Internal","Back"];
	_cam camCommand "inertia on";
	4711 cutText ["","PLAIN",0.01];

	for "_run" from 1 to 2 do
	{
		_speed = 200;
		_height = 2;
		_target = "next";
		if (VAR(_fps0,speed) > 0) then {_speed = VAR(_fps0,speed);};
		if (VAR(_fps0,height) > 0) then {_height = VAR(_fps0,height);};
		if (VAR(_fps0,target) != "") then {_target = VAR(_fps0,target);};
		_camStartPos = VAR(_fps0,center);
		_camStartPos set [2,_height];

		_cam camSetPos _camStartPos;
		_cam camSetTarget (position player);
		_cam camCommit 0;

		if (_run ==2) then
		{
			player sideChat format ["Running benchmark '%1'",missionName];
			sleep 3;
//			starttime = time;
//			[VAR(_fps0,name),100] call start;
			["Benchmark "] spawn measureFPS;
		}
		else
		{
			player sideChat format ["Preloading '%1'",missionName];
			sleep 3;
			["Preloading"] spawn measureFPS;
		};
		for "_c" from 0 to ((count _markers) - 2) do
		{
			_x = EL(_markers,_c);
			_nxt = EL(_markers,_c + 1);

			if (VAR(_x,speed) >0) then {_speed = VAR(_x,speed);};
			if (VAR(_nxt,height) >0) then {_height = VAR(_nxt,height);};
			if (VAR(_nxt,target) != "") then {_target = VAR(_nxt,target);};

			if (_run ==1) then {_speed = 200;};

			_np = VAR(_nxt,center);
			_np set [2,_height];
			_np2 = [];
			switch (_target) do
			{
				case "next":
				{
					_np2 = +_np;
					_np2 set[1,EL(_np,1)+1];
				};
				case "player":
				{
					_np2 = position player;
				};
				default
				{
					_np2 = markerPos _target;
				};
			};
			//player sideChat format ["Moving to %1, speed %2, camera->%3",VAR(_nxt,marker),_speed,_target];
			_cam camSetTarget _np2;
			_cam camCommit 1;
			waitUntil {camCommitted _cam;};
			_cam camSetPos _np;

			_t = (VAR(_x,center) distance VAR(_nxt,center))/_speed;
			_cam camCommit _t;
			waitUntil {camCommitted _cam;};
		};
		showFPS = false;
	};
//	call stopBM;
//	endtime = time;
//	sleep 1;
//	diag_log format ["%1: time: %2, frames: %3, avg fps: %4.",worldName,endtime-starttime,call numFrames,(call numFrames)/(endtime-starttime)];
//	if (!_nolog) then
//	{
//		call present;
//		player sideChat "LOG SAVED";
//	}
//	else
//	{
//		player sideChat "LOG NOT SAVED due to 'nolog' keyword in first marker";
//	};
	sleep 1;
	player sideChat "BENCHMARK DONE";
	endMission "END1";
};