/*------------------------------------------------------------------------------
						VIGNETTE
------------------------------------------------------------------------------*/

float4 VignettePass( float4 colorInput, float2 tex )
{
	float4 vignette = colorInput;
	float2 tc = tex - VignetteCenter;
	tc.x *= (SMAA_PIXEL_SIZE.y / SMAA_PIXEL_SIZE.x);
  float v = length(tc) / VignetteRadius;
  
	//vignette += pow(v, VignetteSlope) * VignetteAmount; //pow - original
	
	/*
	//method 2
	v *= v; // ^2
	v *= v; // ^4
	v *= v; // ^8
	vignette += v * VignetteAmount; //Fewer multiplies
	*/
	
	//method 3
	//vignette += v * v * v * v * v * v * v * v * VignetteAmount; //multiplies
	
	//method 4
	//vignette += exp(v * VignetteSlope - VignetteSlope) * VignetteAmount; //Works but is slower
	
	//method 5 - Seems to work well - reduces banding and remains fast.
	//vignette.rgb += pow(saturate(v-0.5),2.0) * VignetteAmount; //linear + pow 2
	
  //method 6
  //v = saturate(v - 0.5);
	//vignette += v * v * VignetteAmount; //linear + pow 2
	
	/*
  //method 7 - branching only slows it down :(
  v = saturate(v-0.5);
  [branch]if (v)
	vignette += pow(v,2.0) * VignetteAmount; //linear + pow 2
	*/
	
	//method 8 -
	//vignette.rgb = vignette.rgb * (1.0 + pow(saturate(v-0.5),3.0) * VignetteAmount); //linear + pow 2
	
	//9
	vignette.rgb = vignette.rgb * (1.0 + pow(v, VignetteSlope) * VignetteAmount); //pow - multiply
	
	return vignette;
}

float4 VignettePasso( float4 colorInput, float2 tex )
{
	float4 vignette = colorInput;
	float2 tc = tex - VignetteCenter;
	tc.x *= (SMAA_PIXEL_SIZE.y / SMAA_PIXEL_SIZE.x);
	float v = length(tc) / VignetteRadius;
	vignette += pow(v, VignetteSlope) * VignetteAmount;
	return vignette;
}
