<?php

require_once 'config.php';

$error_count = 0;
$max_allowed_errors = 9999999;

foreach ($mods as $mod) {
	runSync($mod[0], $mod[1]);
}

function runSync($auto_config_url, $addon_dir_root) {
	
	$addon_dir_root = add_trailing_slash(&$addon_dir_root);
	$auto_config_url_basedir = format_url_basedir($auto_config_url);
	print("addon_dir_root is: $addon_dir_root\n");
	print("auto_config_url_basedir is: $auto_config_url_basedir\n");
	
	
	$manifest_filename = get_manifest_filename($auto_config_url);
	delete_file($addon_dir_root . $manifest_filename, $addon_dir_root);
	get_manifest_file($addon_dir_root, $auto_config_url);
	
	$manifest_dir = $addon_dir_root . "manifest_dir/";
	print("manifest_filename is: $manifest_filename\n");
	print("manifest_dir is: $manifest_dir\n");
	
	unzipdest($addon_dir_root, $manifest_filename, $manifest_dir);
	
	$xml = simplexml_load_file($manifest_dir . "Addons.xml");
	//print_r($xml->Addons);
	$i = 0;
	foreach ($xml->Addons as $x) {
		$i++;
		//print_r($x);
		$local_file_path = str_replace("\\", "/", $x->Path);
		$local_file_name = $x->Pbo;
		$url = $x->Url;
		$md5 = $x->Md5;
		
		//print($local_file_path . "\n");
		//print($local_file_name . "\n");
		//print($url . "\n");
		//print($md5 . "\n");
	
		$local_file_full = $addon_dir_root . strtolower($local_file_path) . "/" . strtolower($local_file_name);
		if (!file_exists($local_file_full)) {
			print("-- file not found, getting it now... $local_file_full\n");
			get_file($url, $local_file_path, $addon_dir_root, $auto_config_url_basedir);
			extract_file($url, $local_file_path, $addon_dir_root);
			delete_file($addon_dir_root . strtolower($url), $addon_dir_root);
		} else {
			//print("-- file exists, checking md5 now... $local_file_full\n");
			$md5_local = strtoupper(md5_file($local_file_full));
			//print("md5_local is: $md5_local\n");
			//print("md5 is: $md5\n");
			if ($md5_local != $md5) {
				print("-- file has changed... $local_file_full\n");
				print("--                     deleting old file...\n");
				delete_file($local_file_full, $addon_dir_root);
				print("--                     fetching new file...\n");
				get_file($url, $local_file_path, $addon_dir_root, $auto_config_url_basedir);
				extract_file($url, $local_file_path, $addon_dir_root);
				delete_file($addon_dir_root . strtolower($url), $addon_dir_root);
			} else {
				print("-- unchanged, skipping... $local_file_full\n");
			}
		}
	//	if ($i > 10) {
	//		break;
	//	}
	}
	
	delete_file($addon_dir_root . $manifest_filename, $addon_dir_root);
	exec("rm -Rf $manifest_dir", $output, $return_status);
}


function extract_file($url, $local_file_path, $addon_dir_root) {
//	global $addon_dir_root;

	$target_zip_full = $addon_dir_root . strtolower($url);
	$destination_dir = $addon_dir_root . strtolower($local_file_path);
	$cmd = "7z  -y -o$destination_dir e $target_zip_full";
	exec($cmd, $output, $return_status);
	check_error($return_status, false);
}


function get_file($url, $local_file_path, $addon_dir_root, $auto_config_url_basedir) {
//	global $addon_dir_root;
//	global $auto_config_url_basedir;

	$destination_dir = $addon_dir_root . strtolower($local_file_path);
	$url_full = $auto_config_url_basedir . $url;
	//print("destination_dir is: $destination_dir\n");
	//print("url_full is: $url_full\n");
	
	$cmd = "wget -P $destination_dir $url_full 2> /dev/null";
	exec($cmd, $output, $return_status);
	//shell_exec($cmd);
//	check_error($return_status, false);
	if ($return_status != 0) {
		print("-- error fetching file: $url_full\n");
	}
}

function delete_file($local_file_full, $addon_dir_root) {
//	global $addon_dir_root;
	$cmd = "rm $local_file_full 2> /dev/null";
	exec($cmd, $output, $return_status);
	check_error($return_status, false);
}

function format_url_basedir($url_zip) {
	$last_slash = strrpos($url_zip, "/");
	$s = substr($url_zip, 0, $last_slash + 1);
	return $s;
}

function get_manifest_filename($auto_config_url) {
//	global $addon_dir_root;
//        global $auto_config_url;

	$a = explode("/", $auto_config_url);
        return end($a);
}


function get_manifest_file($addon_dir_root, $auto_config_url) {
//	global $addon_dir_root;
//	global $auto_config_url;

	$cmd = "wget -P $addon_dir_root $auto_config_url 2> /dev/null";
	exec($cmd, &$output, &$return_status);

	check_error($return_status, true);
	//print_r($output);
	//print($return_status . "\n");
}

function unzip($path, $filename) {
	unzipdest($path, $filename, $path); //path assumed to also be destination
}

function unzipdest($path, $filename, $destination) {
	//print("destination is: " . $destination . "\n");
	if (!file_exists($destination)) {
		$cmd = "mkdir $destination";
		exec($cmd, $output, $return_status);
		check_error($return_status, true);
	}
	$path = add_trailing_slash($path);
	$fullpath = $path . $filename;
	$cmd = "7z -y -o$destination e $fullpath";
	exec($cmd, $output, $return_status);
	check_error($return_status, true);
}

function add_trailing_slash(&$s) {
	$trailing_slash_pos = strrpos($s, "/");

	if ($trailing_slash_pos != (strlen($s) - 1)) {
        	$s = $s . "/";
	}
	return $s;
}

function check_error($return_status, $fatal) {
/*	global $max_allowed_errors;
	global $error_count;

	//print("return_status is: $return_status");
	if ($return_status != 0 && $fatal) {
		die("fatal error encountered.\n");
	} else if ($return_status != 0 && !$fatal) {
		$error_count++;
		if($error_count > $max_allowed_errors) {
			die("too many errors encountered.\n");
		}
	}
*/
}

?>
