/*
 * version: m720_task_hint 0.1.0
 *
 * Copyright (c) 2010, MIL/DEV 720 (m720@coreland.ath.cx)
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#define TASK_WHITE [1.0,  1.0,  1.0,  1.0]
#define TASK_GREY  [0.75, 0.75, 0.75, 1.0]
#define TASK_GREEN [0.6,  0.8,  0.4,  1.0]
#define TASK_RED   [1.0,  0.1,  0.0,  1.0]

private ["_task", "_task_description", "_task_status", "_task_params"];

_task 			  = _this select 0;
_task_description = (taskDescription _task) select 1;
_task_status	  = toUpper (taskState _task);
_task_params      = switch (_task_status) do {
  case "ASSIGNED":  { [format ["Task assigned: \n%1",  _task_description], TASK_WHITE, "taskCurrent"] };
  case "CANCELED":  { [format ["Task canceled: \n%1",  _task_description], TASK_GREY,  "taskDone"] };
  case "CREATED":   { [format ["Task created: \n%1",   _task_description], TASK_WHITE, "taskNew"] };
  case "FAILED":    { [format ["Task failed: \n%1",    _task_description], TASK_RED,   "taskFailed"] };
  case "SUCCEEDED": { [format ["Task completed: \n%1", _task_description], TASK_GREEN, "taskDone"] };
};

taskHint _task_params;