_text = format ["An Evening On The Coast\n- 2010 MIL/DEV 270 -\n"];
titleText [_text, "BLACK IN", 8];

waitUntil {M720_server_inited};

[] execVM "client_briefing_text.sqf";

M720_main_task = player createSimpleTask ["main_task"];
M720_main_task setSimpleTaskDescription ["Disrupt Russian supplies", "Disrupt Russian supplies", "DISRUPT"];
M720_main_task setTaskState "Assigned";

M720_t0a_task = player createSimpleTask ["t0a", M720_main_task];
M720_t0a_task setSimpleTaskDescription ["Locate fuel shipment", "Locate fuel shipment", "LOCATE FUEL"];
M720_t0a_task setTaskState "Assigned";
[M720_t0a_task] execVM "M720_task_hint.sqf";

M720_t0b_task = player createSimpleTask ["t0b", M720_t0a_task];
M720_t0b_task setSimpleTaskDescription ["Destroy fuel shipment", "Destroy fuel shipment", "DESTROY"];
[M720_t0b_task] execVM "M720_task_hint.sqf";

/* Fuel task supervisor. */
[] spawn {
  waitUntil {M720_fuel_located};
  M720_t0a_task setTaskState "Succeeded";
  [M720_t0a_task] execVM "M720_task_hint.sqf";
  M720_t0b_task setTaskState "Assigned";
  M720_t0b_task setSimpleTaskDestination M720_fuel_pos;
  [M720_t0b_task] execVM "M720_task_hint.sqf";
  waitUntil {M720_fuel_destroyed};
  M720_t0b_task setTaskState "Succeeded";
  [M720_t0b_task] execVM "M720_task_hint.sqf";
};

M720_t1a_task = player createSimpleTask ["t1a", M720_main_task];
M720_t1a_task setSimpleTaskDescription ["Destroy train engines", "Destroy train engines", "DESTROY"];
M720_t1a_task setTaskState "Assigned";
[M720_t1a_task] execVM "M720_task_hint.sqf";

/* Train task supervisor. */
[] spawn {
  waitUntil {M720_trains_destroyed};
  M720_t1a_task setTaskState "Succeeded";
  [M720_t1a_task] execVM "M720_task_hint.sqf";
};

/* Objectives complete? */

waitUntil {M720_objectives_complete};

M720_main_task setTaskState "Succeeded";
[M720_main_task] execVM "M720_task_hint.sqf";
/*
 * Copyright (c) 2010, MIL/DEV 720 (m720@coreland.ath.cx)
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* Extract. */

M720_extract_task = player createSimpleTask ["extract_task"];
M720_extract_task setSimpleTaskDescription ["Extract", "Extract", "EXTRACT"];
M720_extract_task setSimpleTaskDestination (getPos M720_extract_call);
M720_extract_task setTaskState "Assigned";
[M720_extract_task] execVM "M720_task_hint.sqf";
player setCurrentTask M720_extract_task;

waitUntil {M720_extraction_complete || M720_extraction_failed};

if (M720_extraction_complete) then {
  M720_extract_task setTaskState "Succeeded";
  [M720_extract_task] execVM "M720_task_hint.sqf";
} else {
  M720_extract_task setTaskState "Failed";
  [M720_extract_task] execVM "M720_task_hint.sqf";

  /* Failure egg. */
  M720_walk_task = player createSimpleTask ["walk_task"];
  M720_walk_task setSimpleTaskDescription ["Walk home due to USMC pilot incompetence", "Walk home due to USMC pilot incompetence", "WALK"];
  M720_walk_task setSimpleTaskDestination (getMarkerPos "M720_walk_home");
  M720_walk_task setTaskState "Assigned";
  [M720_walk_task] execVM "M720_task_hint.sqf";
  player setCurrentTask M720_walk_task;

  waitUntil {M720_extraction_complete};

  M720_walk_task setTaskState "Succeeded";
  [M720_walk_task] execVM "M720_task_hint.sqf";
};
