/*
 * Copyright (c) 2010, MIL/DEV 720 (m720@coreland.ath.cx)
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Main town force.
 */

M720_DAC_z0_infantry = [
  6,  // 6 groups
  2,  // 2-6 units per group
  60, // 60 waypoints in total
  10  // 10 waypoints per group
];

M720_DAC_z0_wheeled = [
  2,  // 2 groups
  1,  // 2-4 units per group
  20, // 20 waypoints in total
  10  // 10 waypoints per group
];

M720_DAC_z0_meta = [
  0,  // Eastern units
  0,  // Eastern side
  0,  // Behaviour 0 (see dac/DAC_Behaviour.sqf)
  0,  // No camp behaviour
  0   // Default waypoint behaviour
];

M720_DAC_z0_params = [
  "M720_DAC_z0",
  [1, 0, 0],
  M720_DAC_z0_infantry,
  M720_DAC_z0_wheeled,
  [], // No tracked
  [], // No helicopters
  M720_DAC_z0_meta
];

/*
 * Lumber yard.
 */

M720_DAC_z1_infantry = [
  1,  // 1 group
  1,  // 2-4 units per group
  20, // 20 waypoints in total
  20  // 20 waypoints per group
];

M720_DAC_z1_meta = [
  0,  // Eastern units
  0,  // Eastern side
  0,  // Behaviour 0 (see dac/DAC_Behaviour.sqf)
  0,  // No camp behaviour
  0   // Default waypoint behaviour
];

M720_DAC_z1_params = [
  "M720_DAC_z1",
  [2, 0, 0],
  M720_DAC_z1_infantry,
  [], // No wheeled
  [], // No tracked
  [], // No helicopters
  M720_DAC_z1_meta
];

/*
 * Harbour.
 */

M720_DAC_z2_infantry = [
  1,  // 1 group
  1,  // 2-4 units per group
  20, // 20 waypoints in total
  20  // 20 waypoints per group
];

M720_DAC_z2_meta = [
  0,  // Eastern units
  0,  // Eastern side
  0,  // Behaviour 0 (see dac/DAC_Behaviour.sqf)
  0,  // No camp behaviour
  0   // Default waypoint behaviour
];

M720_DAC_z2_params = [
  "M720_DAC_z2",
  [3, 0, 0],
  M720_DAC_z2_infantry,
  [], // No wheeled
  [], // No tracked
  [], // No helicopters
  M720_DAC_z2_meta
];