/*
 * Copyright (c) 2010, MIL/DEV 720 (m720@coreland.ath.cx)
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Initialize fuel shipment.
 */

M720_fuel_locations = [
  M720_fuel_0,
  M720_fuel_1,
  M720_fuel_2,
  M720_fuel_3,
  M720_fuel_4,
  M720_fuel_5,
  M720_fuel_6,
  M720_fuel_7,
  M720_fuel_8,
  M720_fuel_9,
  M720_fuel_10,
  M720_fuel_11
];

M720_fuel_locations_count = count M720_fuel_locations;
M720_fuel_index           = floor (random M720_fuel_locations_count);
M720_fuel_location        = M720_fuel_locations select M720_fuel_index;
M720_fuel_pos             = (getPos M720_fuel_location);
M720_fuel_can_0           = "Land_Ind_TankSmall2" createVehicle M720_fuel_pos;
M720_fuel_can_1           = "Land_Ind_TankSmall2" createVehicle M720_fuel_pos;
M720_fuel_trigger setPos M720_fuel_pos;

publicVariable "M720_fuel_pos";

[] spawn {
  waitUntil {M720_fuel_located};
  waitUntil {
    ((damage M720_fuel_can_0) == 1.0) &&
    ((damage M720_fuel_can_1) == 1.0)
  };
  M720_fuel_destroyed = true;
  publicVariable "M720_fuel_destroyed";
};

/*
 * Destroy trains.
 */

M720_trains_destroyed = false;
publicVariable "M720_trains_destroyed";

[] spawn {
  waitUntil {
    ((damage train_0) == 1.0) &&
    ((damage train_1) == 1.0)
  };
  M720_trains_destroyed = true;
  publicVariable "M720_trains_destroyed";
};

/*
 * Watch objective completion.
 */

M720_objectives_complete = false;
M720_extraction_failed   = false;
M720_extraction_complete = false;
M720_finished            = false;

publicVariable "M720_objectives_complete";
publicVariable "M720_extraction_complete";
publicVariable "M720_extraction_failed";
publicVariable "M720_finished";

/* Helicopter death supervisor. */
[] spawn {
  waitUntil {
    (damage M720_heli_0 > 0.6) || (damage M720_pilot_0 > 0.5) || (fuel M720_heli_0 < 0.2)
  };

  M720_extraction_failed = true;
  publicVariable "M720_extraction_failed";
};

/* Completion and extraction supervisor. */
[] spawn {
  waitUntil {M720_trains_destroyed && M720_fuel_destroyed};
  M720_objectives_complete = true;
  publicVariable "M720_objectives_complete";

  waitUntil {M720_extraction_complete};

  M720_finished = true;
  publicVariable "M720_finished";
};

/*
 * FIN
 */

M720_server_inited = true;
publicVariable "M720_server_inited";