// JTD array search wrapper for the building search script
// by TRexian

// executed by script or trigger
/*
	Recieves parameters: array of groups, array of buildings.
	If more groups than buildings, random groups sent to each building.
	If more buildings than groups, groups will be assigned buildings more or less sequentially.
*/

private ["_grpFM", "_FunctionsManager", "_assignedGroupArray", "_toSearchArray", "_randomizedArray", "_posSelect", "_forEachIndex", "_searchFunc", "_searchGroupElement", "_spawnHandle"];

	if (JTD_searchDebug) then
	{
		diag_log text "Array search initiated";
	};

if (isNil "JTD_bldgsrchPath") then {JTD_bldgsrchPath = "";};
// check for functions
if (isNil "bis_fnc_init") then
{
	createCenter sideLogic;
	_grpFM = createGroup sideLogic;
	_FunctionsManager = _grpFM createUnit ["FunctionsManager", [1, 1, 1], [], 0, "NONE"];
	waitUntil {!isNil "bis_fnc_init"};
};
if (isNil "JTD_bldgSearchFunc") then
{
	JTD_bldgSearchFunc = compile preprocessFileLineNumbers (JTD_bldgsrchPath + "JTD_buildingSearch.sqf");
};
if (isNil "JTD_arrayShuffleFunc") then
{
	JTD_arrayShuffleFunc = compile preprocessFileLineNumbers (JTD_bldgsrchPath + "JTD_arrayShuffle.sqf");
};
if (isNil "JTD_availableFunc") then
{
	JTD_availableFunc = compile preprocessFileLineNumbers (JTD_bldgsrchPath + "JTD_searchersOccupied.sqf");
};
if (isNil "JTD_lockedSearchGroups") then {JTD_lockedSearchGroups = [];};
_assignedGroupArray = _this select 0;
if ((typeName (_assignedGroupArray)) != "ARRAY") exitWith {diag_log text format "Building srch array 1 invalid";};
_toSearchArray = _this select 1;
if ((typeName (_toSearchArray)) != "ARRAY") exitWith {diag_log text format "Building srch array 2 invalid";};

// randomize groups
_randomizedArray = [_assignedGroupArray] call JTD_arrayShuffleFunc;
	if (JTD_searchDebug) then
	{
		diag_log text format ["randomized array: %1", _randomizedArray];
	};
JTD_searchAvailables = _randomizedArray;
_posSelect = [];
if ((count _randomizedArray) >= (count _toSearchArray)) then
{
	//assign each group to a building
	// for each group, assign a building
	{
		_posSelect = getPos _x;
			diag_log text format ["arraySearch opfor: %1", _randomizedArray select _forEachIndex];
			diag_log text format ["arraySearch position: %1", _posSelect];
		_searchFunc = [(_randomizedArray select _forEachIndex), 20, "NEAREST", _posSelect] execVM "JTD_buildingSearch.sqf";
		if (JTD_searchDebug) then
		{
			diag_log text format ["Groups+ : %1 %2", _x, _posSelect];
		};
	} forEach _toSearchArray;
	
}
else
{
	// iterate through the toSearchArray, with available groups
	// must account for groups that get killed
	{
		_searchGroupElement = JTD_searchAvailables select 0;
		if (JTD_searchDebug) then
		{
			diag_log text format ["Buildings+ top availables: %1", JTD_searchAvailables];
		};
		JTD_searchAvailables = JTD_searchAvailables - [_searchGroupElement];
		_spawnHandle = [_searchGroupElement] spawn JTD_availableFunc;
		sleep 3;
		_posSelect = getPos _x;
		_searchFunc = [_searchGroupElement, 20, "NEAREST", _posSelect] execVM "JTD_buildingSearch.sqf";
		waitUntil {(_searchGroupElement in JTD_lockedSearchGroups)};
		if (JTD_searchDebug) then
		{
			diag_log text format ["Buildings+ : %1 %2", _searchGroupElement, _posSelect];
			diag_log text format ["Buildings+ bot availables: %1", JTD_searchAvailables];
		};
		// waituntil count
		waitUntil {(count JTD_searchAvailables) > 0};
	} forEach _toSearchArray;
	
};
