// JTD block search

private ["_groupSelect", "_posSelect", "_radSrch", "_houseArray", "_c", "_searchFunc", "_nameMarker", "_marker"];

diag_log "Block search started";
if (isNil "JTD_bldgsrchPath") then {JTD_bldgsrchPath = "";};
if (isNil "JTD_bldgSearchFunc") then
{
	JTD_bldgSearchFunc = compile preprocessFileLineNumbers (JTD_bldgsrchPath + "JTD_buildingSearch.sqf");
};

// needs group, position and radius
_groupSelect = _this select 0;
if ((typeName (_groupSelect)) == "OBJECT") then {_groupSelect = group (_this select 0)};
_posStart = _this select 1;
if ((typeName (_posStart)) == "OBJECT") then {_posStart = getPos (_this select 0)};
_radSrch = _this select 2;
if (isNil "_radSrch") then {_radSrch = 50};
if (_radSrch < 1) then {_radSrch = 1};
_houseArray = [];
_c = 0;
		if (JTD_searchDebug) then
		{
		diag_log text format ["groupSelect: %1", _groupSelect];
		};

while {alive (leader _groupSelect)} do
{
	// building check
	_houseArray = nearestObjects [_posStart, ["HOUSE"], _radSrch];

	{
		_posSelect = getPos _x;
			diag_log text format ["selected position: %1", _posSelect];
		_searchFunc = [_groupSelect, 10, "NEAREST", _posSelect, true, false] execVM "JTD_buildingSearch.sqf";
		if (JTD_searchDebug) then
		{
			_c = _c + 1;
			_nameMarker = format ["srch_%1", str _c];
			_marker = createMarkerLocal [_nameMarker, [_posStart select 0, _posStart select 1]];
			_marker setMarkerShapeLocal "ICON";
			_marker setMarkerTypeLocal "dot";
			_marker setMarkerSizeLocal [10, 10];
			_marker setMarkerColor "ColorGreenAlpha";
		};		
		waituntil {scriptDone _searchFunc};
	} forEach _houseArray;
	sleep (random 60) + 60;
};