// JTD trigger search from fired EH
// by TRexian

// executed by EH attached to player
// _srchEH = this addEventHandler ["fired", {_this execVM "JTD_searchFiredEH.sqf"};];

private ["_srchEH", "_checkTime", "_shooter", "_shooterPos", "_nearEnemy", "_group", "_searchFunc"];
//diag_log text format ["searchEH activated lock %1", JTD_searchEHLock];
if (isNil "JTD_searchEHLock") then {JTD_searchEHLock = false;};
if (isNil "JTD_bldgsrchPath") then {JTD_bldgsrchPath = "";};
if (JTD_searchEHLock) exitWith {};
JTD_searchEHLock = true;
_checkTime = dayTime;

if (isNil "JTD_bldgSearchFunc") then
{
	JTD_bldgSearchFunc = compile preprocessFileLineNumbers (JTD_bldgsrchPath + "JTD_buildingSearch.sqf");
};

_shooter = _this select 0;
_shooterPos = getPos _shooter;
// may need a search for "MAN" type object instead
_nearEnemy = _shooter findNearestEnemy _shooterPos;	// should return null object if none

if (isNull _nearEnemy) exitWith {
	diag_log text "EH No enemies near.";
	JTD_searchEHLock = false;
	};

_group = group _nearEnemy;
diag_log text format ["searchEH enemy group %1", _group];
if (_group in JTD_lockedSearchGroups) exitWith {
	diag_log text "EH Search group already committed";
	JTD_searchEHLock = false;};
_r = random 1;
if (_r < .5) then
{
	diag_log text "search fired EH inside random";
	_searchFunc = [_group, 50, "RANDOM", _shooterPos] call JTD_bldgSearchFunc;
	if (JTD_searchDebug) then
	{
		diag_log text "EH search initiated";
	};
	waituntil {daytime > (_checkTime + .017)};	// wait for about a minute before allowing another fired EH to be triggered
};
JTD_searchEHLock = false;