/*	ac130_AI_shooting.sqf for AC130-Script
*	@author: LurchiDerLurch
*	@param: nothing
*	@return: nothing
*	@description: 
*/

//local variables
private ["_shoot", "_targets", "_target", "_getWeapon"];

waitUntil {sleep 0.1; (LDL_ac130_active)};

LDL_logic = (createGroup (createCenter sideLogic)) createUnit ["LOGIC", [0, 0, 0], [], 0, ""];

LDL_marker = createMarkerLocal ["Marker", [0,0,0]];
LDL_marker setMarkerShapeLocal "ICON";
LDL_marker setMarkerSizeLocal [0.7, 0.7];
LDL_marker setMarkerTypeLocal "Destroy";	
LDL_marker setMarkerTextLocal "AC-130 Target";	

/*
_shoot = 
{
	if(!LDL_AI_ceaseFire) then
	{
		[_this select 0, _this select 1,_this select 2, _this select 3]spawn
		{
			private ["_pos","_dirh","_dirv", "_logic", "_angles"];
			
			_pos = getPos LDL_gunPosition;
			_dirh = _this select 0;
			_dirv = _this select 1;
			_logic = _this select 3;	
			
			switch (_this select 2) do
			{
				case 0:
				{
					if (!LDL_shootingGun25) then
					{
						//25mm
						for [{_i = 0;},{_i < 15 + random 10},{_i = _i + 1;}] do 
						{
							[_dirh,_dirv,0,_pos]spawn LDL_calculateBullet;
							sleep 0.075;
							_angles = [LDL_gunPosition,_logic]call LDL_getObjectAngles;
							_dirh = [_angles select 0]call LDL_normalizeAngle;
							_dirv = [_angles select 1]call LDL_normalizeAngle;
							_pos = getPos LDL_gunPosition;
						};
					};
				};
				
				case 1:
				{
					if (!LDL_shootingGun40) then
					{						
						//40mm
						for [{_i = 0;},{_i < 1 + random 2},{_i = _i + 1;}] do 
						{
							[_dirh,_dirv,1,_pos]spawn LDL_calculateBullet;
							sleep 0.5;
							_angles = [LDL_gunPosition,_logic]call LDL_getObjectAngles;
							_dirh = [_angles select 0]call LDL_normalizeAngle;
							_dirv = [_angles select 1]call LDL_normalizeAngle;
							_pos = getPos LDL_gunPosition;
						};
					};				
				};
				
				case 2:
				{	
					if (!LDL_shootingGun105) then
					{					
						//105mm
						[_dirh,_dirv,2,_pos]spawn LDL_calculateBullet;
						sleep 3.5;	
					};
				};
			};
		};	
	};	
};
*/

_shoot =
{
	private["_target", "_weapon", "_dif", "_target", "_angles", "_dirh", "_dirv"];
	
	_target = _this select 0;
	_weapon = _this select 1;
	
	_dif = LDL_logic distance _target;
		
	if(_dif < 4000) then
	{
		sleep (_dif/200);	
	};
	
	if (typeName _target == "ARRAY") then
	{
		LDL_logic setPos _target;
	}
	else
	{
		LDL_logic setPos [getPos _target select 0, getPos _target select 1, (getPos _target select 2)+3];
	};
	
	_target = LDL_logic;
	
	LDL_marker setMarkerPosLocal getPos LDL_logic;
	
	_angles = [LDL_gunPosition,_target]call LDL_getObjectAngles;
	_dirh = [_angles select 0]call LDL_normalizeAngle;
	_dirv = [_angles select 1]call LDL_normalizeAngle;
	
	switch (_weapon) do
	{
		case 0:
		{
			if (!LDL_shootingGun25) then
			{
				//25mm
				for [{_i = 0;},{_i < 15 + random 10},{_i = _i + 1;}] do 
				{
					[_dirh,_dirv,0,getPos LDL_gunPosition]spawn LDL_calculateBullet;
					sleep 0.075;
					_angles = [LDL_gunPosition,_target]call LDL_getObjectAngles;
					_dirh = [_angles select 0]call LDL_normalizeAngle;
					_dirv = [_angles select 1]call LDL_normalizeAngle;
				};
			};
		};
		
		case 1:
		{
			if (!LDL_shootingGun40) then
			{						
				//40mm
				for [{_i = 0;},{_i < 1 + random 2},{_i = _i + 1;}] do 
				{
					[_dirh,_dirv,1,getPos LDL_gunPosition]spawn LDL_calculateBullet;
					sleep 0.5;
					_angles = [LDL_gunPosition,_target]call LDL_getObjectAngles;
					_dirh = [_angles select 0]call LDL_normalizeAngle;
					_dirv = [_angles select 1]call LDL_normalizeAngle;
				};
			};				
		};
		
		case 2:
		{	
			if (!LDL_shootingGun105) then
			{					
				//105mm
				[_dirh,_dirv,2,getPos LDL_gunPosition]spawn LDL_calculateBullet;
				sleep 3.5;	
			};
		};
	};
};

_getWeapon =
{
	private["_target", "_weapon"];
	
	_target = _this select 0;
	
	if (typeName _target == "ARRAY") then
	{
		_weapon = 2;
	}
	else
	{
		if(_target isKindOf "LandVehicle" || _target isKindOf "Ship") then
		{
			_weapon = round(random  1)+1; //40mm or 105mm
		}
		else
		{
			_weapon = round(random  1); //25mm or 40mm
		};
	};
	
	_weapon;
};

while {alive LDL_ac130_plane && alive player && !LDL_ac130_abort && LDL_ac130_active} do
{
	sleep 1;
	
	if(LDL_AI_targetAssigned) then
	{
		//Assigned targets by player	
		if (typeName LDL_fixPos == "ARRAY") then
		{
			[LDL_fixPos, 2]call _shoot;
		}
		else
		{
			_i = 0;
			while{alive LDL_fixPos && _i < 3 && typeName LDL_fixPos == "OBJECT"} do
			{
				sleep 1;
				[LDL_fixPos, [LDL_fixPos]call _getWeapon]call _shoot;
				_i = _i + 1;
			};
		};
		
		LDL_AI_targetAssigned = false;
	}
	else
	{
		if(count LDL_AI_targets > 0) then
		{
			//Assigned targets by script
			_target = LDL_AI_targets select 0;

			_i = 0;
			while{alive _target && _i < 3} do
			{
				sleep 1;
				[_target, [_target]call _getWeapon]call _shoot;
				_i = _i + 1;
			};

			LDL_AI_targets = LDL_AI_targets - [_target];
		}
		else
		{
			if(!LDL_AI_ceaseFire) then
			{
				//Search for targets
				_targets = nearestObjects [getPos LDL_cam_rotating_center, ["LandVehicle","Air","Ship", "Man"], LDL_cam_rotating_radius-50];
				{
					
					if(side _x == side player || side _x == civilian) then {_targets = _targets - [_x]};
					
				} forEach _targets;
				
				_target = _targets select 0;
				
				if(count _targets > 0) then
				{
					[_target, [_target]call _getWeapon]call _shoot;
				};	
			};	
		};
	};
	
	
	/*
	if(LDL_AI_targetAssigned) then
	{
		//Assigned targets by player
		_dif = _logic distance LDL_fixPos;
		
		if(_dif < 4000) then
		{
			sleep (_dif/200);	
		};
		
		if (typeName LDL_fixPos == "ARRAY") then
		{
			_logic setPos LDL_fixPos;
		}
		else
		{
			_logic setPos (getPos LDL_fixPos);
		};
		
		_marker setMarkerPosLocal getPos _logic; 
		
		if((LDL_cam_rotating_center distance _logic) <= LDL_cam_rotating_radius-50) then
		{
			_angles = [LDL_gunPosition,_logic]call LDL_getObjectAngles;	
			LDL_guns_dirh = [_angles select 0]call LDL_normalizeAngle;
			LDL_guns_dirv = [_angles select 1]call LDL_normalizeAngle;
			[LDL_guns_dirh,LDL_guns_dirv,2,_logic]call _shoot;
			
			sleep 1;
		}
		else
		{
			LDL_ac130_plane sideChat "Out of range.";
		};
		
		LDL_AI_targetAssigned = false;
	}
	else
	{
		if(count LDL_AI_targets > 0) then
		{
			//Assigned targets by script
			_target = LDL_AI_targets select 0;
			
			_dif = _target distance LDL_fixPos;
		
			if(_dif < 4000) then
			{
				sleep (_dif/200);	
			};
			
			_marker setMarkerPosLocal getPos _target; 
		
			if((LDL_cam_rotating_center distance _target) <= LDL_cam_rotating_radius-50) then
			{
				_angles = [LDL_gunPosition,_target]call LDL_getObjectAngles;	
				LDL_guns_dirh = [_angles select 0]call LDL_normalizeAngle;
				LDL_guns_dirv = [_angles select 1]call LDL_normalizeAngle;
				[LDL_guns_dirh,LDL_guns_dirv,2,_target]call _shoot;
				
				sleep 1;
			}
			else
			{
				LDL_ac130_plane sideChat "Out of range.";
			};
			
			LDL_AI_targets = LDL_AI_targets - [_target];
		}
		else
		{
			//Search for targets
			_heavyTargets = nearestObjects [getPos LDL_cam_rotating_center, ["LandVehicle","Air","Ship"], LDL_cam_rotating_radius-50];
			{
				
				if(side _x == side player || side _x == civilian) then {_heavyTargets = _heavyTargets - [_x]};
				
			} forEach _heavyTargets;
			
			_lightTargets = nearestObjects [getPos LDL_cam_rotating_center, ["Man"], LDL_cam_rotating_radius-50];
			{
				
				if(side _x == side player || side _x == civilian) then {_lightTargets = _lightTargets - [_x]};
				
			} forEach _lightTargets;
			
			if((count _heavyTargets > 5 || count _lightTargets == 0) && count _heavyTargets > 0) then
			{
				_target = (_heavyTargets select (ceil(random count _heavyTargets)-1));
				_dif = _logic distance _target;
				
				if(_dif < 4000) then
				{
					sleep (_dif/200);	
				};
				
				_logic setPos getPos _target;
				_marker setMarkerPosLocal getPos _logic; 
				_angles = [LDL_gunPosition,_logic]call LDL_getObjectAngles;
				
				LDL_guns_dirh = [_angles select 0]call LDL_normalizeAngle;
				LDL_guns_dirv = [_angles select 1]call LDL_normalizeAngle;
				_rand = random  1;
				_num = round(_rand)+1; 
				[LDL_guns_dirh,LDL_guns_dirv,_num,_logic]call _shoot;
			}
			else
			{
				if(count _lightTargets > 0) then
				{
					_target = (_lightTargets select (ceil(random count _lightTargets)-1));
					_dif = _logic distance _target;
					
					if(_dif < 4000) then
					{
						sleep (_dif/200);	
					};
				
					_logic setPos getPos _target;
					_marker setMarkerPosLocal getPos _logic; 
					_angles = [LDL_gunPosition,_logic]call LDL_getObjectAngles;
					
					LDL_guns_dirh = [_angles select 0]call LDL_normalizeAngle;
					LDL_guns_dirv = [_angles select 1]call LDL_normalizeAngle;
					_rand = random  1;
					_num = round(_rand);  
					[LDL_guns_dirh,LDL_guns_dirv,_num,_logic]call _shoot;
				};
			};
		};
	};
	*/
};

LDL_AI_targets = [];
deleteMarkerLocal "Marker";
deleteVehicle LDL_logic;
LDL_scriptTerminated = LDL_scriptTerminated + 1;