/*	ac130_att_camera.sqf by LurchiDerLurch for AC130-Script
*	@author: LurchiDerLurch
*	@param: nothing
*	@return: nothing
*	@description: 
*/

//local variables
private ["_360View", "_logic", "_display", "_ac130_cam_target", "_xM", "_yM", "_difh", "_difv", "_angles"];

disableSerialization;

waitUntil {sleep 0.1; (LDL_ac130_active)};

_360View = LDL_view360;
_logic = (createGroup (createCenter sideLogic)) createUnit ["LOGIC", [0, 0, 0], [], 0, ""];
_display = (finddisplay 1000);
_ac130_cam_target = (createGroup (createCenter sideLogic)) createUnit ["LOGIC", [0,0,0], [], 0, ""];

while {LDL_ac130_active && !LDL_ac130_abort} do
{
	sleep 0.005;
	
	//Crosshairs
	(_display displayctrl 1007) ctrlSetTextColor [1,1,1,1];
	
	//Camera
	if(LDL_viewMode == 0) then
	{
		//Interior
		LDL_ac130_cam setPos (LDL_ac130_plane modelToWorld[-5,-5,-2]); //Camera is attached to the plane
		[LDL_ac130_cam, _ac130_cam_target, _logic, LDL_view360, (getDir LDL_ac130_plane + 90)]call LDL_camera_interior;
	}
	else
	{
		//Exterior
		_ac130_cam_target setPos (LDL_ac130_plane modelToWorld[-50,0,0]); //Camera target is attached to the plane
		LDL_gunPosition setPos (LDL_ac130_plane modelToWorld[-5,-5,-2]); //Position from where the AC130 shoots
		[LDL_ac130_cam, _ac130_cam_target, _logic, LDL_view360, (getDir LDL_ac130_plane + 90)]call LDL_camera_exterior;
	};
	
	//Commit camera changes	
	LDL_ac130_cam camSetTarget _ac130_cam_target;
	LDL_ac130_cam camSetFov LDL_camFov;
	LDL_ac130_cam camCommit 0;
	
};

LDL_scriptTerminated = LDL_scriptTerminated + 1;