/*	ac130_camera_exterior.sqf by LurchiDerLurch for AC130-Script
*	@author: LurchiDerLurch
*	@param: nothing
*	@return: nothing
*	@description: 
*/

//local variables
private["_ac130_cam_target", "_difv","_difh", "_logic", "_angles", "_xM", "_yM", "_display", "_360View", "_angleH"];

disableSerialization;

_ac130_cam = _this select 0;
_ac130_cam_target = _this select 1;
_logic = _this select 2;
_360View = _this select 3;
_angleH = _this select 4;

_xM = LDL_mousePosition select 0;
_yM = LDL_mousePosition select 1;

_display = (finddisplay 1000);
LDL_guns_enabled = true;

_difv = [LDL_cam_dirv + _yM*1.5 - 180]call LDL_normalizeAngle;
_logic setPos (screenToWorld [0.5,0.5]);
_angles = [LDL_gunPosition,_logic]call LDL_getObjectAngles;
LDL_guns_dirh = [_angles select 0]call LDL_normalizeAngle;
LDL_guns_dirv = [_angles select 1]call LDL_normalizeAngle;

//vertical
if(!(_difv < 80) && !(_difv > 179)) then
{
	LDL_cam_dirv = LDL_cam_dirv + _yM*1.5;
}
else
{
	if(_difv < 80) then
	{
		LDL_cam_dirv = 260;
	}
	else
	{
		LDL_cam_dirv = 359;
	};
};

//horizontal
LDL_cam_dirh = LDL_cam_dirh + _xM*1.5;

LDL_cam_dirv = [LDL_cam_dirv]call LDL_normalizeAngle;
LDL_cam_dirh = [LDL_cam_dirh]call LDL_normalizeAngle;

[_ac130_cam,_ac130_cam_target,LDL_cam_dirh - 180,90 + LDL_cam_dirv,120]call LDL_setSphericPosition;
		
//guns
_difh = [(LDL_guns_dirh - _angleH)]call LDL_normalizeAngle;
_difv = [LDL_guns_dirv - 180]call LDL_normalizeAngle;

if(_difh < 90 || _difh > 270 || _difv < 100 || _difv > 190 && !_360View) then
{
	(_display displayctrl 1007) ctrlSetTextColor [1,1,1,0];
	LDL_guns_enabled = false;
};