/*	ac130_camera_interior.sqf by LurchiDerLurch for AC130-Script
*	@author: LurchiDerLurch
*	@param: nothing
*	@return: nothing
*	@description: 
*/

//local variables
private["_ac130_cam_target", "_logic", "_xM", "_yM", "_angles", "_cam_set_dirh", "_cam_set_dirv", "_difh", "_difv", "_angleH"];

_ac130_cam = _this select 0;
_ac130_cam_target = _this select 1;
_logic = _this select 2;
_360View = _this select 3;
_xM = LDL_mousePosition select 0;
_yM = LDL_mousePosition select 1;
_angleH = _this select 4;

if(LDL_fixCam) then
{
	if (typeName LDL_fixPos == "ARRAY") then
	{
		_logic setPos LDL_fixPos;
	}
	else
	{
		_logic setPos (getPos LDL_fixPos);
	};

	_angles = [_ac130_cam, _logic]call LDL_getObjectAngles;
	_cam_set_dirh = [_angles select 0]call LDL_normalizeAngle;
	_cam_set_dirv = [_angles select 1]call LDL_normalizeAngle;
}
else
{
	_cam_set_dirh = LDL_cam_dirh + _xM*1.5;
	_cam_set_dirv = LDL_cam_dirv + _yM*1.5;
};

_difh = [(_cam_set_dirh - _angleH)]call LDL_normalizeAngle;
_difv = [_cam_set_dirv - 180]call LDL_normalizeAngle;



//horizontal
if((!(_difh < 90) && !(_difh > 270)) || _360View) then
{
	LDL_cam_dirh = _cam_set_dirh;
}
else
{
	if(_difh < 90) then
	{
		LDL_cam_dirh = [_angleH + 90]call LDL_normalizeAngle;
	}
	else
	{
		LDL_cam_dirh = [_angleH - 90]call LDL_normalizeAngle;
	};
};

//vertical
if(!(_difv < 100) && !(_difv > 190)) then
{
	LDL_cam_dirv = _cam_set_dirv;
}
else
{
	if(_difv > 100) then
	{
		LDL_cam_dirv = 10;
	}
	else
	{
		LDL_cam_dirv = 280;
	};
};

LDL_cam_dirv = [LDL_cam_dirv]call LDL_normalizeAngle;
LDL_cam_dirh = [LDL_cam_dirh]call LDL_normalizeAngle;

[_ac130_cam_target,_ac130_cam,LDL_cam_dirh,90 - LDL_cam_dirv,5000]call LDL_setSphericPosition; //Camera target