/*	ac130_rot_camera.sqf by LurchiDerLurch for AC130-Script
*	@author: LurchiDerLurch
*	@param: nothing
*	@return: nothing
*	@description: 
*/

//local variables
private["_logic", "_display", "_ac130_cam_target", "_ac130_cam_fake"];

disableSerialization;

waitUntil {sleep 0.1; (LDL_ac130_active)};

_logic = (createGroup (createCenter sideLogic)) createUnit ["LOGIC", [0, 0, 0], [], 0, ""];
_display = (finddisplay 1000);
_ac130_cam_target = (createGroup (createCenter sideLogic)) createUnit ["LOGIC", [0,0,0], [], 0, ""];
_ac130_cam_fake = (createGroup (createCenter sideLogic)) createUnit ["LOGIC", [0,0,0], [], 0, ""];

while {LDL_ac130_active && !LDL_ac130_abort} do
{
	sleep 0.005;
	
	//Angle for rotating (if plane is not heading to another position)
	//Due to synchronisation (avoid shaking camera) these lines are here (camera script)
	if(LDL_flyMode != 3) then
	{
		LDL_cam_rotating_angle = [LDL_cam_rotating_angle - 0.1]call LDL_normalizeAngle;
		LDL_plane_set_roll = -15;
	}
	else
	{
		LDL_plane_set_roll = 0;
	};
	
	//Plane position
	[LDL_ac130_plane, LDL_cam_rotating_center, LDL_cam_rotating_radius, LDL_cam_rotating_angle, LDL_cam_rotating_height]call LDL_setCirclePosition; 
	
	//Crosshairs
	(_display displayctrl 1007) ctrlSetTextColor [1,1,1,1];
	
	//Camera
	if(LDL_viewMode == 0) then
	{
		//Interior
		if(!LDL_opticalZoom) then
		{
			if(LDL_plane_type == "UAV") then
			{
				LDL_ac130_cam setPos (LDL_ac130_plane modelToWorld[0,4,-1.5]);
			}
			else
			{
				[LDL_ac130_cam, LDL_cam_rotating_center, LDL_cam_rotating_radius-5, LDL_cam_rotating_angle, LDL_cam_rotating_height]call LDL_setCirclePosition; //camera rotates around the center
			};
			
			[LDL_ac130_cam, _ac130_cam_target, _logic, LDL_view360, LDL_cam_rotating_angle]call LDL_camera_interior;
		}
		else
		{
			if(LDL_plane_type == "UAV") then
			{
				_ac130_cam_fake setPos (LDL_ac130_plane modelToWorld[0,4,-1.5]);
			}
			else
			{
				[_ac130_cam_fake, LDL_cam_rotating_center, LDL_cam_rotating_radius-5, LDL_cam_rotating_angle, LDL_cam_rotating_height]call LDL_setCirclePosition; //camera rotates around the center
			};
			
			[_ac130_cam_fake, _ac130_cam_target, _logic, LDL_view360, LDL_cam_rotating_angle]call LDL_camera_interior;
			
			[LDL_ac130_cam,_ac130_cam_fake,LDL_cam_dirh,90 - LDL_cam_dirv,LDL_cam_zoom]call LDL_setSphericPosition;
		};
	}
	else
	{
		//Exterior
		[_ac130_cam_target, LDL_cam_rotating_center, LDL_cam_rotating_radius-50, LDL_cam_rotating_angle, LDL_cam_rotating_height]call LDL_setCirclePosition; //Camera target rotates around the center
		[LDL_ac130_cam, _ac130_cam_target, _logic, LDL_view360, LDL_cam_rotating_angle]call LDL_camera_exterior;
	};
	
	[LDL_gunPosition, LDL_cam_rotating_center, LDL_cam_rotating_radius-5, LDL_cam_rotating_angle, LDL_cam_rotating_height]call LDL_setCirclePosition; //Position from where the AC130 shoots
	
	//Commit camera changes	
	LDL_ac130_cam camSetTarget _ac130_cam_target;
	LDL_ac130_cam camSetFov LDL_camFov;
	LDL_ac130_cam camCommit 0;
};

LDL_scriptTerminated = LDL_scriptTerminated + 1;
