/*	uav_HUD.sqf by LurchiDerLurch for AC130-Script
*	@author: LurchiDerLurch
*	@param: nothing
*	@return: nothing
*	@description: 
*/

private["_difh", "_difv", "_x", "_y", "_display", "_effect", "_structured", "_infos", "_secTotal", "_s", "_m", "_h", "_screen"];

disableSerialization;

_difh = [(LDL_cam_dirh - LDL_cam_rotating_angle)]call LDL_normalizeAngle;
_difv = [LDL_cam_dirv - 180]call LDL_normalizeAngle;
_display = (finddisplay 1000);

//Compass
for [{_i = 0;_j = 0},{_i < 360;_j < 4},{_i = _i + 90;_j = _j + 1}] do 
{
	_x = (0.5- 0.035 + sin(_i - LDL_cam_dirh)*(SafeZoneW/4 - SafeZoneW/100));
	_y = (0.5- 0.025 - cos(_i - LDL_cam_dirh)*(SafeZoneH/4 - SafeZoneH/100));
	
	(_display displayCtrl 1009+_j) ctrlSetPosition [_x,_y];
	(_display displayCtrl 1009+_j) ctrlCommit 0;
};

//Diference indicator  
_x = (SafeZoneX + SafeZoneW/2 - SafeZoneW/200)+sin(_difh)*SafeZoneW/16;
_y = (SafeZoneY + SafeZoneH - SafeZoneH/4);

(_display displayCtrl 1013) ctrlSetPosition [_x,_y];
(_display displayCtrl 1013) ctrlCommit 0;
(_display displayCtrl 1014) ctrlSetPosition [_x,_y];
(_display displayCtrl 1014) ctrlCommit 0;

_x = (SafeZoneX + SafeZoneW - SafeZoneW/4);
_y = (SafeZoneY + SafeZoneH/2)+sin(_difv)*SafeZoneH/16;

(_display displayCtrl 1015) ctrlSetPosition [_x,_y];
(_display displayCtrl 1015) ctrlCommit 0;
(_display displayCtrl 1016) ctrlSetPosition [_x,_y];
(_display displayCtrl 1016) ctrlCommit 0;

//Info Display Left
_effect = switch(LDL_cameraEffect) do
{
	case 2:
	{
		"FLIR W";	
	};
	
	case 3:
	{
		"FLIR B";	
	};
	
	case 4:
	{
		"NVG";	
	};
	
	default
	{
		"";
	};
};

_structured = composeText [""];
_infos = 
[
	format ["H: %1  V: %2",round(LDL_cam_dirh),round(LDL_cam_dirv)],
	format ["Alt: %1m (%2 ASL)",round(getPos LDL_ac130_plane select 2),round(getPosASL LDL_ac130_plane select 2)],
	format[""],
	lineBreak,
	format ["%1",_effect]
];

{
	_structured = composeText [_structured,_x,lineBreak];
} forEach _infos;

(_display displayctrl 1003) ctrlSetStructuredText _structured;

_secTotal = (time-LDL_startTime);

_s = _secTotal MOD 60;
_m  = (_secTotal/60) MOD 60;
_h  = (_secTotal/60/60) MOD 24;
			
//Info Display Right
_structured = composeText [""];
_infos = 
[
	format ["Hellfire: 10/10"],
	lineBreak,
	format ["%1 : %2",date select 3,date select 4],
	format ["%1:%2:%3",floor(_h),floor(_m),floor(_s)],
	format[""]
];

if(LDL_showBlink && !LDL_disableBlink) then
{
	_infos  = _infos + [parseText "<t size='0.6'>Infantry Strobe</t>"];
};

if(LDL_showTroops && !LDL_disableHUD) then
{
	_infos  = _infos + [parseText "<t size='0.6'>Vehicle Detection</t>"];
};

{
	_structured = composeText [_structured,_x,lineBreak];

} forEach _infos;
(_display displayctrl 1004) ctrlSetStructuredText _structured;

//Range
(_display displayctrl 1008) ctrlSetText format ["Range: %1",round(LDL_ac130_plane distance (screenToWorld [0.5,0.5]))];
 
//Center
_screen = worldToScreen (getPos LDL_cam_rotating_center);

if (count _screen != 2) then
{                              
	_screen = [-1,-1];
};
     
(_display displayCtrl 1005) ctrlSetPosition [(_screen select 0)-SafeZoneW/32,(_screen select 1)-SafeZoneH/32];
(_display displayCtrl 1005) ctrlCommit 0;